/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.listeners;

import com.carrotsearch.ant.tasks.junit4.FormattingUtils;
import com.carrotsearch.ant.tasks.junit4.JUnit4;
import com.carrotsearch.ant.tasks.junit4.Pluralize;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.WriterOutputStream;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Charsets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.MoreObjects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscribe;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharSink;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closeables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.FileWriteMode;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files;
import com.carrotsearch.ant.tasks.junit4.events.IEvent;
import com.carrotsearch.ant.tasks.junit4.events.IStreamEvent;
import com.carrotsearch.ant.tasks.junit4.events.SuiteStartedEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestFinishedEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedQuitEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedStartEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteStartedEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedTestResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.ChildBootstrap;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.HeartBeatEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.JvmOutputEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.PartialOutputEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.TestStatus;
import com.carrotsearch.ant.tasks.junit4.events.mirrors.FailureMirror;
import com.carrotsearch.ant.tasks.junit4.listeners.AggregatedEventListener;
import com.carrotsearch.ant.tasks.junit4.listeners.PrefixedWriter;
import com.carrotsearch.ant.tasks.junit4.listeners.StackTraceFilter;
import com.carrotsearch.ant.tasks.junit4.listeners.TextReport$1;
import com.carrotsearch.ant.tasks.junit4.listeners.TextReport$OutputMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tools.ant.BuildException;
import org.junit.runner.Description;

public class TextReport
implements AggregatedEventListener {
    private static final String indent = "   > ";
    private static final String stdoutIndent = "  1> ";
    private static final String stderrIndent = "  2> ";
    private static final String FAILURE_MARKER = " <<<";
    private static final String FAILURE_STRING = " <<< FAILURES!";
    private static final int DEFAULT_MAX_LINE_WIDTH = 16384;
    private static Set UNICODE_ENCODINGS = new HashSet<String>(Arrays.asList("UTF-8", "UTF-16LE", "UTF-16", "UTF-16BE", "UTF-32"));
    private static EnumMap statusNames = new EnumMap(TestStatus.class);
    private boolean showThrowable = true;
    private boolean showStackTraces = true;
    private TextReport$OutputMode outputMode = TextReport$OutputMode.ALWAYS;
    private boolean showSuiteSummary = true;
    private boolean showEmptySuites = false;
    private final EnumMap displayStatus = new EnumMap(TestStatus.class);
    private Writer output;
    private int maxClassNameColumns;
    private boolean useSimpleNames;
    private boolean timestamps;
    private File outputFile;
    private boolean append;
    private int forkedJvmCount;
    private String jvmIdFormat;
    private PrefixedWriter outWriter;
    private PrefixedWriter errWriter;
    private WriterOutputStream outStream;
    private WriterOutputStream errStream;
    private int showNumFailuresAtEnd;
    private List failedTests;
    private List stackFilters;
    private int totalSuites;
    private AtomicInteger totalErrors;
    private AtomicInteger suitesCompleted;
    private String seed;

    public TextReport() {
        for (TestStatus testStatus : TestStatus.values()) {
            this.displayStatus.put(testStatus, true);
        }
        this.maxClassNameColumns = Integer.MAX_VALUE;
        this.useSimpleNames = false;
        this.timestamps = false;
        this.showNumFailuresAtEnd = 3;
        this.failedTests = new ArrayList();
        this.stackFilters = new ArrayList();
        this.totalErrors = new AtomicInteger();
        this.suitesCompleted = new AtomicInteger();
    }

    public void setShowStatusError(boolean bl) {
        this.displayStatus.put(TestStatus.ERROR, bl);
    }

    public void setShowStatusFailure(boolean bl) {
        this.displayStatus.put(TestStatus.FAILURE, bl);
    }

    public void setShowStatusOk(boolean bl) {
        this.displayStatus.put(TestStatus.OK, bl);
    }

    public void setShowStatusIgnored(boolean bl) {
        this.displayStatus.put(TestStatus.IGNORED, bl);
        this.displayStatus.put(TestStatus.IGNORED_ASSUMPTION, bl);
    }

    public void setMaxClassNameColumns(int n) {
        this.maxClassNameColumns = n;
    }

    public void setUseSimpleNames(boolean bl) {
        this.useSimpleNames = bl;
    }

    public void setTimestamps(boolean bl) {
        this.timestamps = bl;
    }

    public void addConfigured(StackTraceFilter stackTraceFilter) {
        this.stackFilters.add(stackTraceFilter);
    }

    public void setShowThrowable(boolean bl) {
        this.showThrowable = bl;
    }

    public void setShowStackTraces(boolean bl) {
        this.showStackTraces = bl;
    }

    public void setShowOutput(String string) {
        try {
            this.outputMode = TextReport$OutputMode.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("showOutput accepts any of: " + Arrays.toString((Object[])TextReport$OutputMode.values()) + ", value is not valid: " + string);
        }
    }

    public void setShowNumFailures(int n) {
        this.showNumFailuresAtEnd = n;
    }

    public void setShowEmptySuites(boolean bl) {
        this.showEmptySuites = bl;
    }

    public void setShowSuiteSummary(boolean bl) {
        this.showSuiteSummary = bl;
    }

    public void setFile(File file) {
        if (!file.getName().isEmpty()) {
            this.outputFile = file;
        }
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    @Override
    public void setOuter(JUnit4 jUnit4) {
        this.seed = jUnit4.getSeed();
        if (this.outputFile != null) {
            try {
                Files.createParentDirs(this.outputFile);
                CharSink charSink = this.append ? Files.asCharSink(this.outputFile, Charsets.UTF_8, FileWriteMode.APPEND) : Files.asCharSink(this.outputFile, Charsets.UTF_8, new FileWriteMode[0]);
                this.output = charSink.openBufferedStream();
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        } else {
            if (!UNICODE_ENCODINGS.contains(Charset.defaultCharset().name())) {
                jUnit4.log("Your default console's encoding may not display certain unicode glyphs: " + Charset.defaultCharset().name(), 2);
            }
            this.output = new TextReport$1(this, new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        }
    }

    @Subscribe
    public void onStart(AggregatedStartEvent aggregatedStartEvent) {
        this.totalSuites = aggregatedStartEvent.getSuiteCount();
        this.logShort("Executing " + this.totalSuites + Pluralize.pluralize(this.totalSuites, " suite") + " with " + aggregatedStartEvent.getSlaveCount() + Pluralize.pluralize(aggregatedStartEvent.getSlaveCount(), " JVM") + ".\n", false);
        this.forkedJvmCount = aggregatedStartEvent.getSlaveCount();
        this.jvmIdFormat = " J%-" + (1 + (int)Math.floor(Math.log10(this.forkedJvmCount))) + "d";
        this.outWriter = new PrefixedWriter(stdoutIndent, this.output, 16384);
        this.errWriter = new PrefixedWriter(stderrIndent, this.output, 16384);
    }

    @Subscribe
    public void onChildBootstrap(ChildBootstrap childBootstrap) {
        this.logShort("Started J" + childBootstrap.getSlave().id + " PID(" + childBootstrap.getSlave().getPidString() + ").");
    }

    @Subscribe
    public void onHeartbeat(HeartBeatEvent heartBeatEvent) {
        this.logShort("HEARTBEAT J" + heartBeatEvent.getSlave().id + " PID(" + heartBeatEvent.getSlave().getPidString() + "): " + FormattingUtils.formatTime(heartBeatEvent.getCurrentTime()) + ", stalled for " + FormattingUtils.formatDurationInSeconds(heartBeatEvent.getNoEventDuration()) + " at: " + (heartBeatEvent.getDescription() == null ? "<unknown>" : FormattingUtils.formatDescription(heartBeatEvent.getDescription())));
    }

    @Subscribe
    public void onQuit(AggregatedQuitEvent aggregatedQuitEvent) {
        if (this.showNumFailuresAtEnd > 0 && !this.failedTests.isEmpty()) {
            List list = this.failedTests;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\nTests with failures [seed: ").append(this.seed).append("]");
            if (list.size() > this.showNumFailuresAtEnd) {
                list = list.subList(0, this.showNumFailuresAtEnd);
                stringBuilder.append(" (first " + this.showNumFailuresAtEnd + " out of " + this.failedTests.size() + ")");
            }
            stringBuilder.append(":\n");
            for (Description description : list) {
                stringBuilder.append("  - ").append(FormattingUtils.formatDescription(description, true)).append("\n");
            }
            stringBuilder.append("\n");
            this.logShort(stringBuilder, false);
        }
        if (this.output != null) {
            Closeables.close(this.output, true);
        }
    }

    @Subscribe
    public void onSuiteStart(AggregatedSuiteStartedEvent aggregatedSuiteStartedEvent) {
        Charset charset = aggregatedSuiteStartedEvent.getSlave().getCharset();
        this.outStream = new WriterOutputStream((Writer)this.outWriter, charset, 16384, true);
        this.errStream = new WriterOutputStream((Writer)this.errWriter, charset, 16384, true);
        if (this.showSuiteSummary && this.isPassthrough()) {
            SuiteStartedEvent suiteStartedEvent = aggregatedSuiteStartedEvent.getSuiteStartedEvent();
            this.emitSuiteStart(suiteStartedEvent.getDescription(), suiteStartedEvent.getStartTimestamp());
        }
    }

    @Subscribe
    public void onOutput(PartialOutputEvent partialOutputEvent) {
        if (this.isPassthrough()) {
            switch (partialOutputEvent.getEvent().getType()) {
                case APPEND_STDERR: {
                    ((IStreamEvent)((Object)partialOutputEvent.getEvent())).copyTo(this.errStream);
                    break;
                }
                case APPEND_STDOUT: {
                    ((IStreamEvent)((Object)partialOutputEvent.getEvent())).copyTo(this.outStream);
                    break;
                }
            }
        }
    }

    @Subscribe
    public void onJvmOutput(JvmOutputEvent jvmOutputEvent) {
        String string = Integer.toString(jvmOutputEvent.getSlave().id);
        this.output.append(">>> JVM J").append(string).append(" emitted unexpected output (verbatim) ----\n");
        try (BufferedReader bufferedReader = Files.newReader(jvmOutputEvent.getJvmOutputFile(), jvmOutputEvent.getSlave().getCharset());){
            CharStreams.copy(bufferedReader, this.output);
        }
        this.output.append("<<< JVM J" + string + ": EOF ----\n");
    }

    @Subscribe
    public void onTestResult(AggregatedTestResultEvent aggregatedTestResultEvent) {
        if (this.isPassthrough() && ((Boolean)this.displayStatus.get((Object)aggregatedTestResultEvent.getStatus())).booleanValue()) {
            this.flushOutput();
            this.emitStatusLine(aggregatedTestResultEvent, aggregatedTestResultEvent.getStatus(), aggregatedTestResultEvent.getExecutionTime());
        }
        if (!aggregatedTestResultEvent.isSuccessful() && this.showNumFailuresAtEnd > 0) {
            this.failedTests.add(aggregatedTestResultEvent.getDescription());
        }
    }

    @Subscribe
    public void onSuiteResult(AggregatedSuiteResultEvent aggregatedSuiteResultEvent) {
        int n = this.suitesCompleted.incrementAndGet();
        if (aggregatedSuiteResultEvent.isSuccessful() && aggregatedSuiteResultEvent.getTests().isEmpty() && !this.showEmptySuites) {
            return;
        }
        if (!this.isPassthrough()) {
            if (this.showSuiteSummary) {
                this.emitSuiteStart(aggregatedSuiteResultEvent.getDescription(), aggregatedSuiteResultEvent.getStartTimestamp());
            }
            this.emitBufferedEvents(aggregatedSuiteResultEvent);
        }
        if (!aggregatedSuiteResultEvent.getFailures().isEmpty() && ((Boolean)this.displayStatus.get((Object)TestStatus.ERROR)).booleanValue()) {
            this.emitStatusLine(aggregatedSuiteResultEvent, TestStatus.ERROR, 0L);
        }
        if (!aggregatedSuiteResultEvent.getFailures().isEmpty() && this.showNumFailuresAtEnd > 0) {
            this.failedTests.add(aggregatedSuiteResultEvent.getDescription());
        }
        if (this.showSuiteSummary) {
            this.emitSuiteEnd(aggregatedSuiteResultEvent, n);
        }
    }

    private void emitBufferedEvents(AggregatedSuiteResultEvent aggregatedSuiteResultEvent) {
        IdentityHashMap<TestFinishedEvent, AggregatedTestResultEvent> identityHashMap = new IdentityHashMap<TestFinishedEvent, AggregatedTestResultEvent>();
        for (Object object : aggregatedSuiteResultEvent.getTests()) {
            identityHashMap.put(((AggregatedTestResultEvent)object).getTestFinishedEvent(), (AggregatedTestResultEvent)object);
        }
        boolean bl = this.outputMode != TextReport$OutputMode.NEVER && (this.outputMode == TextReport$OutputMode.ALWAYS && !this.isPassthrough() || this.outputMode == TextReport$OutputMode.ONERROR && !aggregatedSuiteResultEvent.isSuccessful());
        for (IEvent iEvent : aggregatedSuiteResultEvent.getEventStream()) {
            switch (iEvent.getType()) {
                case APPEND_STDOUT: {
                    if (!bl) break;
                    ((IStreamEvent)((Object)iEvent)).copyTo(this.outStream);
                    break;
                }
                case APPEND_STDERR: {
                    if (!bl) break;
                    ((IStreamEvent)((Object)iEvent)).copyTo(this.errStream);
                    break;
                }
                case TEST_FINISHED: {
                    assert (identityHashMap.containsKey(iEvent));
                    AggregatedTestResultEvent aggregatedTestResultEvent = (AggregatedTestResultEvent)identityHashMap.get(iEvent);
                    if (!((Boolean)this.displayStatus.get((Object)aggregatedTestResultEvent.getStatus())).booleanValue()) break;
                    this.flushOutput();
                    this.emitStatusLine(aggregatedTestResultEvent, aggregatedTestResultEvent.getStatus(), aggregatedTestResultEvent.getExecutionTime());
                }
            }
        }
        if (bl) {
            this.flushOutput();
        }
    }

    private void flushOutput() {
        this.outStream.flush();
        this.outWriter.completeLine();
        this.errStream.flush();
        this.errWriter.completeLine();
    }

    private void emitSuiteStart(Description description, long l) {
        String string = description.getDisplayName();
        if (this.useSimpleNames && string.lastIndexOf(46) >= 0) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        this.logShort(this.shortTimestamp(l) + "Suite: " + FormattingUtils.padTo(this.maxClassNameColumns, string, "[...]"));
    }

    private void emitSuiteEnd(AggregatedSuiteResultEvent aggregatedSuiteResultEvent, int n) {
        int n2;
        int n3;
        assert (this.showSuiteSummary);
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = this.totalErrors.addAndGet(aggregatedSuiteResultEvent.isSuccessful() ? 0 : 1);
        stringBuilder.append(String.format(Locale.ENGLISH, "%sCompleted [%d/%d%s]%s in %.2fs, ", this.shortTimestamp(aggregatedSuiteResultEvent.getStartTimestamp() + aggregatedSuiteResultEvent.getExecutionTime()), n, this.totalSuites, n4 == 0 ? "" : " (" + n4 + "!)", aggregatedSuiteResultEvent.getSlave().slaves > 1 ? " on J" + aggregatedSuiteResultEvent.getSlave().id : "", (double)aggregatedSuiteResultEvent.getExecutionTime() / 1000.0));
        stringBuilder.append(aggregatedSuiteResultEvent.getTests().size()).append(Pluralize.pluralize(aggregatedSuiteResultEvent.getTests().size(), " test"));
        int n5 = aggregatedSuiteResultEvent.getFailureCount();
        if (n5 > 0) {
            stringBuilder.append(", ").append(n5).append(Pluralize.pluralize(n5, " failure"));
        }
        if ((n3 = aggregatedSuiteResultEvent.getErrorCount()) > 0) {
            stringBuilder.append(", ").append(n3).append(Pluralize.pluralize(n3, " error"));
        }
        if ((n2 = aggregatedSuiteResultEvent.getIgnoredCount()) > 0) {
            stringBuilder.append(", ").append(n2).append(" skipped");
        }
        if (!aggregatedSuiteResultEvent.isSuccessful()) {
            stringBuilder.append(FAILURE_STRING);
        }
        stringBuilder.append("\n");
        this.logShort(stringBuilder, false);
    }

    private void emitStatusLine(AggregatedResultEvent aggregatedResultEvent, TestStatus testStatus, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.shortTimestamp(aggregatedResultEvent.getStartTimestamp()));
        stringBuilder.append(Strings.padEnd((String)statusNames.get((Object)testStatus), 8, ' '));
        stringBuilder.append(FormattingUtils.formatDurationInSeconds(l));
        if (this.forkedJvmCount > 1) {
            stringBuilder.append(String.format(Locale.ENGLISH, this.jvmIdFormat, aggregatedResultEvent.getSlave().id));
        }
        stringBuilder.append(" | ");
        stringBuilder.append(FormattingUtils.formatDescription(aggregatedResultEvent.getDescription()));
        if (!aggregatedResultEvent.isSuccessful()) {
            stringBuilder.append(FAILURE_MARKER);
        }
        stringBuilder.append("\n");
        if (this.showThrowable) {
            Writer writer;
            Object object;
            if (testStatus == TestStatus.IGNORED && aggregatedResultEvent instanceof AggregatedTestResultEvent) {
                object = new StringWriter();
                writer = new PrefixedWriter(indent, (Writer)object, 16384);
                writer.write("Cause: ");
                writer.write(((AggregatedTestResultEvent)aggregatedResultEvent).getCauseForIgnored());
                ((PrefixedWriter)writer).completeLine();
                stringBuilder.append(((StringWriter)object).toString());
            }
            if (!(object = aggregatedResultEvent.getFailures()).isEmpty()) {
                writer = new StringWriter();
                PrefixedWriter prefixedWriter = new PrefixedWriter(indent, writer, 16384);
                int n = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    FailureMirror failureMirror = (FailureMirror)iterator.next();
                    ++n;
                    if (failureMirror.isAssumptionViolation()) {
                        prefixedWriter.write(String.format(Locale.ENGLISH, "Assumption #%d: %s", n, MoreObjects.firstNonNull(failureMirror.getMessage(), "(no message)")));
                        continue;
                    }
                    prefixedWriter.write(String.format(Locale.ENGLISH, "Throwable #%d: %s", n, this.showStackTraces ? this.filterStackTrace(failureMirror.getTrace()) : failureMirror.getThrowableString()));
                }
                prefixedWriter.completeLine();
                if (((StringWriter)writer).getBuffer().length() > 0) {
                    stringBuilder.append(((StringWriter)writer).toString());
                }
            }
        }
        this.logShort(stringBuilder);
    }

    private String filterStackTrace(String string) {
        for (StackTraceFilter stackTraceFilter : this.stackFilters) {
            string = stackTraceFilter.apply(string);
        }
        return string;
    }

    private void logShort(CharSequence charSequence, boolean bl) {
        int n;
        if (bl) {
            for (n = charSequence.length(); n > 0 && Character.isWhitespace(charSequence.charAt(n - 1)); --n) {
            }
        }
        char[] cArray = new char[n + 1];
        for (int i = 0; i < n; ++i) {
            cArray[i] = charSequence.charAt(i);
        }
        cArray[n] = 10;
        this.output.write(cArray);
    }

    private void logShort(CharSequence charSequence) {
        this.logShort(charSequence, true);
    }

    private boolean isPassthrough() {
        return this.forkedJvmCount == 1 && this.outputMode == TextReport$OutputMode.ALWAYS;
    }

    private String shortTimestamp(long l) {
        if (this.timestamps) {
            return "[" + FormattingUtils.formatTimestamp(l) + "] ";
        }
        return "";
    }

    static {
        for (TestStatus testStatus : TestStatus.values()) {
            statusNames.put(testStatus, testStatus == TestStatus.IGNORED_ASSUMPTION ? "IGNOR/A" : testStatus.toString());
        }
    }
}

