/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.slave;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.MethodGlobFilter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.events.BootstrapEvent;
import com.carrotsearch.ant.tasks.junit4.events.Serializer;
import com.carrotsearch.ant.tasks.junit4.events.SuiteFailureEvent;
import com.carrotsearch.ant.tasks.junit4.slave.EventsOutputStream;
import com.carrotsearch.ant.tasks.junit4.slave.JvmExit;
import com.carrotsearch.ant.tasks.junit4.slave.NullWriter;
import com.carrotsearch.ant.tasks.junit4.slave.OrderedRunNotifier;
import com.carrotsearch.ant.tasks.junit4.slave.RunListenerEmitter;
import com.carrotsearch.ant.tasks.junit4.slave.SlaveMain$1;
import com.carrotsearch.ant.tasks.junit4.slave.SlaveMain$2;
import com.carrotsearch.ant.tasks.junit4.slave.SlaveMain$3;
import com.carrotsearch.ant.tasks.junit4.slave.StdInLineIterator;
import com.carrotsearch.ant.tasks.junit4.slave.StreamFlusherDecorator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class SlaveMain {
    public static final int ERR_EXCEPTION = 240;
    public static final int ERR_NO_JUNIT = 239;
    public static final int ERR_OLD_JUNIT = 238;
    public static final int ERR_OOM = 237;
    static volatile Object lastResortMemory = new byte[0x500000];
    static Class oomClass = OutOfMemoryError.class;
    public static final String OPTION_FREQUENT_FLUSH = "-flush";
    public static final String OPTION_SYSOUTS = "-sysouts";
    public static final String OPTION_STDIN = "-stdin";
    public static final String OPTION_EVENTSFILE = "-eventsfile";
    public static final String OPTION_DEBUGSTREAM = "-debug";
    public static final String SYSPROP_FIRERUNNERFAILURE = SlaveMain.class.getName() + ".fireRunnerFailure";
    private final Serializer serializer;
    private static PrintStream warnings;
    private boolean flushFrequently = false;
    private File debugMessagesFile;
    private static boolean multiplexStdStreams;

    public SlaveMain(Serializer serializer) {
        this.serializer = serializer;
    }

    private void execute(Iterator iterator) {
        block10: {
            OrderedRunNotifier orderedRunNotifier = new OrderedRunNotifier();
            Result result = new Result();
            Writer writer = this.debugMessagesFile == null ? new NullWriter() : new OutputStreamWriter((OutputStream)new FileOutputStream(this.debugMessagesFile), "UTF-8");
            orderedRunNotifier.addListener(result.createListener());
            orderedRunNotifier.addListener(new StreamFlusherDecorator(new SlaveMain$1(this, new RunListenerEmitter(this.serializer))));
            orderedRunNotifier.addListener(new SlaveMain$2(this, writer));
            String string = Strings.emptyToNull(System.getProperty(SysGlobals.SYSPROP_TESTMETHOD()));
            Filter filter = Filter.ALL;
            if (string != null) {
                filter = new MethodGlobFilter(string);
            }
            this.debug(writer, "Entering main suite loop.");
            block7: while (true) {
                try {
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        this.debug(writer, "Instantiating: " + string2);
                        Class clazz = this.instantiate(string2);
                        if (clazz == null) continue;
                        Request request = Request.aClass((Class)clazz);
                        try {
                            Runner runner = request.getRunner();
                            filter.apply((Object)runner);
                            orderedRunNotifier.fireTestRunStarted(runner.getDescription());
                            this.debug(writer, "Runner.run(" + string2 + ")");
                            runner.run((RunNotifier)orderedRunNotifier);
                            this.debug(writer, "Runner.done(" + string2 + ")");
                            orderedRunNotifier.fireTestRunFinished(result);
                            continue block7;
                        }
                        catch (NoTestsRemainException noTestsRemainException) {
                        }
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    this.debug(writer, "Main suite loop error: " + throwable);
                    throw throwable;
                }
            }
            finally {
                this.debug(writer, "Leaving main suite loop.");
                writer.close();
            }
        }
    }

    private void debug(Writer writer, String string) {
        writer.write(string);
        writer.write("\n");
        writer.flush();
    }

    private Class instantiate(String string) {
        try {
            return Class.forName(string, false, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            try {
                this.serializer.serialize(new SuiteFailureEvent(new Failure(Description.createSuiteDescription((String)string, (Annotation[])new Annotation[0]), throwable)));
                if (this.flushFrequently) {
                    this.serializer.flush();
                }
            }
            catch (Exception exception) {
                SlaveMain.warn("Could not report failure back to master.", throwable);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n = 0;
        Serializer serializer = null;
        try {
            Object object;
            Object object2;
            ArrayDeque<String> arrayDeque = new ArrayDeque<String>(Arrays.asList(stringArray));
            boolean bl = false;
            boolean bl2 = false;
            File file = null;
            boolean bl3 = false;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (!arrayDeque.isEmpty()) {
                object2 = arrayDeque.pop();
                if (((String)object2).equals(OPTION_FREQUENT_FLUSH)) {
                    bl2 = true;
                    continue;
                }
                if (((String)object2).equals(OPTION_STDIN)) {
                    bl3 = true;
                    continue;
                }
                if (((String)object2).equals(OPTION_SYSOUTS)) {
                    multiplexStdStreams = true;
                    continue;
                }
                if (((String)object2).equals(OPTION_EVENTSFILE)) {
                    file = new File(arrayDeque.pop());
                    if (!file.isFile() || file.length() <= 0L) continue;
                    object = new RandomAccessFile(file, "rw");
                    ((RandomAccessFile)object).setLength(0L);
                    ((RandomAccessFile)object).close();
                    continue;
                }
                if (((String)object2).startsWith(OPTION_DEBUGSTREAM)) {
                    bl = true;
                    continue;
                }
                if (((String)object2).startsWith("@")) {
                    arrayDeque.addAll(Arrays.asList(SlaveMain.readArgsFile(((String)object2).substring(1))));
                    continue;
                }
                arrayList.add(object2);
            }
            if (file == null) {
                throw new IOException("You must specify communication channel for events.");
            }
            serializer = new Serializer(new EventsOutputStream(file)).serialize(new BootstrapEvent()).flush();
            SlaveMain.redirectStreams(serializer, bl2);
            object2 = new SlaveMain(serializer);
            ((SlaveMain)object2).flushFrequently = bl2;
            ((SlaveMain)object2).debugMessagesFile = bl ? new File(file.getAbsolutePath() + ".debug") : null;
            object = bl3 ? new StdInLineIterator(((SlaveMain)object2).serializer) : Collections.emptyList().iterator();
            super.execute(Iterators.concat(arrayList.iterator(), (Iterator)object));
            if (System.getProperty(SYSPROP_FIRERUNNERFAILURE) != null) {
                throw new Exception(System.getProperty(SYSPROP_FIRERUNNERFAILURE));
            }
        }
        catch (Throwable throwable) {
            lastResortMemory = null;
            SlaveMain.tryWaitingForGC();
            if (throwable.getClass() == oomClass) {
                n = 237;
                SlaveMain.warn("JVM out of memory.", throwable);
            }
            n = 240;
            SlaveMain.warn("Exception at main loop level.", throwable);
        }
        try {
            if (serializer != null) {
                try {
                    serializer.close();
                }
                catch (Throwable throwable) {
                    SlaveMain.warn("Exception closing serializer.", throwable);
                }
            }
        }
        finally {
            JvmExit.halt(n);
        }
    }

    private static void tryWaitingForGC() {
        long l = System.currentTimeMillis() + 2000L;
        while (System.currentTimeMillis() < l) {
            System.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readArgsFile(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).isEmpty() || string2.startsWith("#")) continue;
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void redirectStreams(Serializer serializer, boolean bl) {
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        warnings = System.err;
        AccessController.doPrivileged(new SlaveMain$3(printStream, serializer, bl, printStream2));
    }

    public static void warn(String string, Throwable throwable) {
        PrintStream printStream = warnings == null ? System.err : warnings;
        try {
            printStream.print("WARN: ");
            printStream.print(string);
            if (throwable != null) {
                printStream.print(" -> ");
                try {
                    throwable.printStackTrace(printStream);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    printStream.print(throwable.getClass().getName());
                    printStream.print(": ");
                    printStream.print(throwable.getMessage());
                    printStream.println(" (stack unavailable; OOM)");
                }
            } else {
                printStream.println();
            }
            printStream.flush();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            printStream.println("ERROR: Couldn't even serialize a warning (out of memory).");
        }
        catch (Throwable throwable2) {
            printStream.println("ERROR: Couldn't even serialize a warning.");
        }
    }

    static /* synthetic */ void access$000(SlaveMain slaveMain, Writer writer, String string) {
        slaveMain.debug(writer, string);
    }

    static /* synthetic */ Serializer access$100(SlaveMain slaveMain) {
        return slaveMain.serializer;
    }

    static /* synthetic */ boolean access$300() {
        return multiplexStdStreams;
    }

    static {
        multiplexStdStreams = false;
    }
}

