/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util.rawQuerying;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.query.RawQueryRequest;
import com.couchbase.client.core.message.query.RawQueryResponse;
import com.couchbase.client.core.message.search.SearchQueryRequest;
import com.couchbase.client.core.message.search.SearchQueryResponse;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.FtsConsistencyTimeoutException;
import com.couchbase.client.java.error.FtsMalformedRequestException;
import com.couchbase.client.java.error.QueryExecutionException;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.queries.AbstractFtsQuery;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import java.io.IOException;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class AsyncRawQueryExecutor {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(AsyncRawQueryExecutor.class);
    private final String bucket;
    private final String username;
    private final String password;
    private final ClusterFacade core;

    public AsyncRawQueryExecutor(String bucket, String password, ClusterFacade core) {
        this(bucket, bucket, password, core);
    }

    public AsyncRawQueryExecutor(String bucket, String username, String password, ClusterFacade core) {
        this.bucket = bucket;
        this.username = username;
        this.password = password;
        this.core = core;
    }

    public Observable<JsonObject> n1qlToJsonObject(N1qlQuery query) {
        return this.n1qlToRawCustom(query, new Func1<TranscoderUtils.ByteBufToArray, JsonObject>(){

            public JsonObject call(TranscoderUtils.ByteBufToArray converted) {
                try {
                    return (JsonObject)JacksonTransformers.MAPPER.readValue(converted.byteArray, converted.offset, converted.length, JsonObject.class);
                }
                catch (IOException e) {
                    throw new TranscodingException("Unable to deserialize the N1QL raw response", e);
                }
            }
        });
    }

    public Observable<String> n1qlToRawJson(N1qlQuery query) {
        return this.n1qlToRawCustom(query, new Func1<TranscoderUtils.ByteBufToArray, String>(){

            public String call(TranscoderUtils.ByteBufToArray converted) {
                return new String(converted.byteArray, converted.offset, converted.length, CharsetUtil.UTF_8);
            }
        });
    }

    public <T> Observable<T> n1qlToRawCustom(final N1qlQuery query, final Func1<TranscoderUtils.ByteBufToArray, T> deserializer) {
        return OnSubscribeDeferAndWatch.deferAndWatch(new Func0<Observable<RawQueryResponse>>(){

            public Observable<RawQueryResponse> call() {
                RawQueryRequest request = RawQueryRequest.jsonQuery((String)query.n1ql().toString(), (String)AsyncRawQueryExecutor.this.bucket, (String)AsyncRawQueryExecutor.this.username, (String)AsyncRawQueryExecutor.this.password);
                return AsyncRawQueryExecutor.this.core.send((CouchbaseRequest)request);
            }
        }).map(new Func1<RawQueryResponse, T>(){

            public T call(RawQueryResponse response) {
                try {
                    if (response.httpStatusCode() == 200) {
                        Object object = deserializer.call((Object)TranscoderUtils.byteBufToByteArray(response.jsonResponse()));
                        return object;
                    }
                    LOGGER.debug("Unable to perform raw N1QL query (see exception), body was: " + response.jsonResponse().toString(CharsetUtil.UTF_8));
                    throw new QueryExecutionException("Unable to perform raw N1QL query: " + response.httpStatusCode() + " - " + response.httpStatusMsg(), JsonObject.empty());
                }
                finally {
                    ReferenceCountUtil.release((Object)response.jsonResponse());
                }
            }
        });
    }

    public Observable<JsonObject> ftsToJsonObject(SearchQuery query) {
        return this.ftsToRawCustom(query, new Func1<String, JsonObject>(){

            public JsonObject call(String stringResponse) {
                return JsonObject.fromJson(stringResponse);
            }
        });
    }

    public Observable<String> ftsToRawJson(SearchQuery query) {
        return this.ftsToRawCustom(query, new Func1<String, String>(){

            public String call(String stringResponse) {
                return stringResponse;
            }
        });
    }

    public <T> Observable<T> ftsToRawCustom(final SearchQuery query, final Func1<String, T> deserializer) {
        final String indexName = query.indexName();
        AbstractFtsQuery queryPart = query.query();
        return Observable.defer((Func0)new Func0<Observable<SearchQueryResponse>>(){

            public Observable<SearchQueryResponse> call() {
                SearchQueryRequest request = new SearchQueryRequest(indexName, query.export().toString(), AsyncRawQueryExecutor.this.bucket, AsyncRawQueryExecutor.this.username, AsyncRawQueryExecutor.this.password);
                return AsyncRawQueryExecutor.this.core.send((CouchbaseRequest)request);
            }
        }).map(new Func1<SearchQueryResponse, T>(){

            public T call(SearchQueryResponse response) {
                if (response.status().isSuccess()) {
                    return deserializer.call((Object)response.payload());
                }
                if (response.status() == ResponseStatus.INVALID_ARGUMENTS) {
                    throw new FtsMalformedRequestException(response.payload());
                }
                if (response.status() == ResponseStatus.FAILURE) {
                    throw new FtsConsistencyTimeoutException();
                }
                throw new CouchbaseException("Could not query search index, " + response.status() + ": " + response.payload());
            }
        });
    }
}

