/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.analytics.AnalyticsMetrics;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryResult;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryRow;
import com.couchbase.client.java.document.json.JsonObject;
import rx.Observable;
import rx.functions.Func1;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class DefaultAsyncAnalyticsQueryResult
implements AsyncAnalyticsQueryResult {
    private final Observable<AsyncAnalyticsQueryRow> rows;
    private final Observable<Object> signature;
    private final Observable<AnalyticsMetrics> info;
    private final boolean parsingSuccess;
    private final Observable<JsonObject> errors;
    private final Observable<String> finalStatus;
    private final String requestId;
    private final String clientContextId;

    public DefaultAsyncAnalyticsQueryResult(Observable<AsyncAnalyticsQueryRow> rows, Observable<Object> signature, Observable<AnalyticsMetrics> info, Observable<JsonObject> errors, Observable<String> finalStatus, boolean parsingSuccess, String requestId, String clientContextId) {
        this.rows = rows;
        this.signature = signature;
        this.info = info;
        this.errors = errors;
        this.finalStatus = finalStatus;
        this.parsingSuccess = parsingSuccess;
        this.requestId = requestId;
        this.clientContextId = clientContextId;
    }

    @Override
    public Observable<AsyncAnalyticsQueryRow> rows() {
        return this.rows;
    }

    @Override
    public Observable<Object> signature() {
        return this.signature;
    }

    @Override
    public Observable<AnalyticsMetrics> info() {
        return this.info;
    }

    @Override
    public Observable<Boolean> finalSuccess() {
        return this.finalStatus.map((Func1)new Func1<String, Boolean>(){

            public Boolean call(String status) {
                return "success".equalsIgnoreCase(status) || "completed".equalsIgnoreCase(status);
            }
        });
    }

    @Override
    public Observable<String> status() {
        return this.finalStatus;
    }

    @Override
    public boolean parseSuccess() {
        return this.parsingSuccess;
    }

    @Override
    public Observable<JsonObject> errors() {
        return this.errors;
    }

    @Override
    public String requestId() {
        return this.requestId;
    }

    @Override
    public String clientContextId() {
        return this.clientContextId;
    }
}

