/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter;

import dm.jdbc.desc.Configuration;
import dm.jdbc.desc.DmProperties;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.DpcFilter;
import dm.jdbc.filter.Filter;
import dm.jdbc.filter.FilterChain;
import dm.jdbc.filter.Filterable$FldrInfo;
import dm.jdbc.filter.Filterable$LogInfo;
import dm.jdbc.filter.Filterable$RWInfo;
import dm.jdbc.filter.Filterable$StatInfo;
import dm.jdbc.filter.custom.CustomFilter;
import dm.jdbc.filter.fldr.FldrFilter;
import dm.jdbc.filter.log.LogFilter;
import dm.jdbc.filter.reconnect.ReconnectFilter;
import dm.jdbc.filter.stat.StatFilter;
import dm.jdbc.rw.RWFilter;
import dm.jdbc.rw.RWFilter2;
import java.util.ArrayList;

public abstract class Filterable {
    protected FilterChain filterChain = null;
    public Filterable$RWInfo rwInfo = null;
    public Filterable$LogInfo logInfo = null;
    public Filterable$StatInfo statInfo = null;
    public Filterable$FldrInfo fldrInfo = null;
    protected long ID = -1L;

    public abstract long getID();

    public Filterable(DmdbConnection dmdbConnection, DmProperties dmProperties) {
        this.filterChain = this.createFilterChain(dmdbConnection, dmProperties);
    }

    public FilterChain createFilterChain(DmdbConnection dmdbConnection, DmProperties dmProperties) {
        FilterChain filterChain = null;
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        DmProperties dmProperties2 = dmProperties = dmProperties == null && dmdbConnection != null ? dmdbConnection.props : dmProperties;
        if (dmProperties != null && dmProperties.contains(Configuration.customFilter)) {
            arrayList.add(CustomFilter.getInstance(dmProperties.getString(Configuration.customFilter)));
        }
        if (dmdbConnection != null) {
            if (DmSvcConf.GLOBAL.logLevel != 0) {
                arrayList = arrayList == null ? new ArrayList<Filter>() : arrayList;
                arrayList.add(LogFilter.getInstance());
                this.logInfo = new Filterable$LogInfo(this);
            }
            if (DmSvcConf.GLOBAL.statEnable) {
                arrayList = arrayList == null ? new ArrayList() : arrayList;
                arrayList.add(StatFilter.getInstance());
                this.statInfo = new Filterable$StatInfo(this);
            }
            if (dmdbConnection.epGroup != null && dmdbConnection.epGroup.reconnect != 0) {
                arrayList = arrayList == null ? new ArrayList() : arrayList;
                arrayList.add(ReconnectFilter.getInstance());
            }
            if (dmdbConnection.mppOpt > 0) {
                arrayList = arrayList == null ? new ArrayList<Filter>() : arrayList;
                arrayList.add(FldrFilter.getInstance());
                this.fldrInfo = new Filterable$FldrInfo(this);
            }
            if (dmdbConnection.epGroup != null && dmdbConnection.epGroup.cluster == 5) {
                arrayList = arrayList == null ? new ArrayList<Filter>() : arrayList;
                arrayList.add(DpcFilter.getInstance());
            }
            if (dmdbConnection.rwSeparate > 0) {
                arrayList = arrayList == null ? new ArrayList() : arrayList;
                arrayList.add(dmdbConnection.rwSeparate >= 3 ? RWFilter.getInstance() : RWFilter2.getInstance());
                this.rwInfo = new Filterable$RWInfo(this);
            }
        } else if (dmProperties != null) {
            if (Configuration.parseLogLevel(dmProperties) != 0) {
                arrayList = arrayList == null ? new ArrayList<Filter>() : arrayList;
                arrayList.add(LogFilter.getInstance());
                this.logInfo = new Filterable$LogInfo(this);
            }
            if (dmProperties.getBoolean(Configuration.statEnable)) {
                arrayList = arrayList == null ? new ArrayList<Filter>() : arrayList;
                arrayList.add(StatFilter.getInstance());
                this.statInfo = new Filterable$StatInfo(this);
            }
            if (dmProperties.getInt(Configuration.reconnect) != 0) {
                arrayList = arrayList == null ? new ArrayList<Filter>() : arrayList;
                arrayList.add(ReconnectFilter.getInstance());
            }
            if (dmProperties.getInt(Configuration.mppOpt) > 0) {
                arrayList = arrayList == null ? new ArrayList<Filter>() : arrayList;
                arrayList.add(FldrFilter.getInstance());
                this.fldrInfo = new Filterable$FldrInfo(this);
            }
            if (Configuration.parseCluster(dmProperties) == 5) {
                arrayList = arrayList == null ? new ArrayList<Filter>() : arrayList;
                arrayList.add(DpcFilter.getInstance());
            }
            int n2 = 0;
            n2 = dmProperties.getInt(Configuration.rwSeparate);
            if (n2 > 0) {
                arrayList = arrayList == null ? new ArrayList<Filter>() : arrayList;
                arrayList.add(n2 >= 3 ? RWFilter.getInstance() : RWFilter2.getInstance());
                this.rwInfo = new Filterable$RWInfo(this);
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            filterChain = new FilterChain(arrayList.toArray(new Filter[0]));
        }
        return filterChain;
    }
}

