/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.spark.connector.CollectionAppend$;
import com.datastax.spark.connector.CollectionBehavior;
import com.datastax.spark.connector.CollectionColumnName;
import com.datastax.spark.connector.CollectionOverwrite$;
import com.datastax.spark.connector.CollectionPrepend$;
import com.datastax.spark.connector.CollectionRemove$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.ListType;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.writer.BatchGroupingKey;
import com.datastax.spark.connector.writer.BatchGroupingKey$None$;
import com.datastax.spark.connector.writer.BatchGroupingKey$Partition$;
import com.datastax.spark.connector.writer.BatchGroupingKey$ReplicaSet$;
import com.datastax.spark.connector.writer.BatchStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.GroupingBatchBuilder;
import com.datastax.spark.connector.writer.PerRowWriteOptionValue;
import com.datastax.spark.connector.writer.QueryExecutor;
import com.datastax.spark.connector.writer.RateLimiter;
import com.datastax.spark.connector.writer.RateLimiter$;
import com.datastax.spark.connector.writer.RichStatement;
import com.datastax.spark.connector.writer.RoutingKeyGenerator;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.StaticWriteOptionValue;
import com.datastax.spark.connector.writer.TTLOption;
import com.datastax.spark.connector.writer.TTLOption$;
import com.datastax.spark.connector.writer.TableWriter$;
import com.datastax.spark.connector.writer.TimestampOption;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteOptionValue;
import java.io.IOException;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.OutputMetricsUpdater;
import org.apache.spark.metrics.OutputMetricsUpdater$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016<&/\u001b;fe*\u00111\u0001B\u0001\u0007oJLG/\u001a:\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005AA-\u0019;bgR\f\u0007PC\u0001\f\u0003\r\u0019w.\\\u0002\u0001+\tqah\u0005\u0003\u0001\u001fUA\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0011-%\u0011q#\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00033qi\u0011A\u0007\u0006\u00037\u0011\tA!\u001e;jY&\u0011QD\u0007\u0002\b\u0019><w-\u001b8h\u0011!)\u0001A!A!\u0002\u0013y\u0002C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\r\u0019\u0017\u000f\\\u0005\u0003I\u0005\u0012!cQ1tg\u0006tGM]1D_:tWm\u0019;pe\"Aa\u0005\u0001B\u0001B\u0003%q%\u0001\u0005uC\ndW\rR3g!\t\u0001\u0003&\u0003\u0002*C\tAA+\u00192mK\u0012+g\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u00039\u0019w\u000e\\;n]N+G.Z2u_J\u00042!\f\u00193\u001b\u0005q#BA\u0018\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003c9\u0012!\"\u00138eKb,GmU3r!\t\u0019D'D\u0001\u0005\u0013\t)DAA\u0005D_2,XN\u001c*fM\"Aq\u0007\u0001B\u0001B\u0003%\u0001(A\u0005s_^<&/\u001b;feB\u0019\u0011H\u000f\u001f\u000e\u0003\tI!a\u000f\u0002\u0003\u0013I{wo\u0016:ji\u0016\u0014\bCA\u001f?\u0019\u0001!Qa\u0010\u0001C\u0002\u0001\u0013\u0011\u0001V\t\u0003\u0003\u0012\u0003\"\u0001\u0005\"\n\u0005\r\u000b\"a\u0002(pi\"Lgn\u001a\t\u0003!\u0015K!AR\t\u0003\u0007\u0005s\u0017\u0010\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0003%9(/\u001b;f\u0007>tg\r\u0005\u0002:\u0015&\u00111J\u0001\u0002\n/JLG/Z\"p]\u001aDQ!\u0014\u0001\u0005\n9\u000ba\u0001P5oSRtDCB(Q#J\u001bF\u000bE\u0002:\u0001qBQ!\u0002'A\u0002}AQA\n'A\u0002\u001dBQa\u000b'A\u00021BQa\u000e'A\u0002aBQ\u0001\u0013'A\u0002%CqA\u0016\u0001C\u0002\u0013\u0005q+\u0001\u0007lKf\u001c\b/Y2f\u001d\u0006lW-F\u0001Y!\tIFL\u0004\u0002\u00115&\u00111,E\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\#!1\u0001\r\u0001Q\u0001\na\u000bQb[3zgB\f7-\u001a(b[\u0016\u0004\u0003b\u00022\u0001\u0005\u0004%\taV\u0001\ni\u0006\u0014G.\u001a(b[\u0016Da\u0001\u001a\u0001!\u0002\u0013A\u0016A\u0003;bE2,g*Y7fA!9a\r\u0001b\u0001\n\u00039\u0017aC2pYVlgNT1nKN,\u0012\u0001\u001b\t\u0004[%D\u0016B\u00016/\u0005\r\u0019V-\u001d\u0005\u0007Y\u0002\u0001\u000b\u0011\u00025\u0002\u0019\r|G.^7o\u001d\u0006lWm\u001d\u0011\t\u000f9\u0004!\u0019!C\u0001_\u000691m\u001c7v[:\u001cX#\u00019\u0011\u00075J\u0017\u000f\u0005\u0002!e&\u00111/\t\u0002\n\u0007>dW/\u001c8EK\u001aDa!\u001e\u0001!\u0002\u0013\u0001\u0018\u0001C2pYVlgn\u001d\u0011\t\u0013]\u0004\u0001R1A\u0005\u0002\u00119\u0016\u0001G9vKJLH+Z7qY\u0006$X-V:j]\u001eLen]3si\"A\u0011\u0010\u0001E\u0001B\u0003&\u0001,A\rrk\u0016\u0014\u0018\u0010V3na2\fG/Z+tS:<\u0017J\\:feR\u0004\u0003\"B>\u0001\t\u0013a\u0018a\u00053fY\u0016$X-U;fef$V-\u001c9mCR,GC\u0001-~\u0011\u0015q(\u00101\u0001\u0000\u00035!W\r\\3uK\u000e{G.^7ogB\u00191'!\u0001\n\u0007\u0005\rAA\u0001\bD_2,XN\\*fY\u0016\u001cGo\u001c:\t\u0015\u0005\u001d\u0001\u0001#b\u0001\n\u0003!q+\u0001\rrk\u0016\u0014\u0018\u0010V3na2\fG/Z+tS:<W\u000b\u001d3bi\u0016D\u0011\"a\u0003\u0001\u0011\u0003\u0005\u000b\u0015\u0002-\u00023E,XM]=UK6\u0004H.\u0019;f+NLgnZ+qI\u0006$X\r\t\u0005\u000b\u0003\u001f\u0001\u0001R1A\u0005\n\u0005E\u0011!\u0004;j[\u0016\u001cH/Y7q'B,7-\u0006\u0002\u0002\u0014A!\u0001#!\u0006Y\u0013\r\t9\"\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0015\u0005m\u0001\u0001#A!B\u0013\t\u0019\"\u0001\buS6,7\u000f^1naN\u0003Xm\u0019\u0011\t\u0015\u0005}\u0001\u0001#b\u0001\n\u0013\t\t#\u0001\u0006ui2,e.\u00192mK\u0012,\"!a\t\u0011\u0007A\t)#C\u0002\u0002(E\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002,\u0001A\t\u0011)Q\u0005\u0003G\t1\u0002\u001e;m\u000b:\f'\r\\3eA!I\u0011q\u0006\u0001\t\u0006\u0004%IaV\u0001\f_B$\u0018n\u001c8t'B,7\rC\u0005\u00024\u0001A\t\u0011)Q\u00051\u0006aq\u000e\u001d;j_:\u001c8\u000b]3dA!I\u0011q\u0007\u0001C\u0002\u0013%\u0011\u0011E\u0001\u0010SN\u001cu.\u001e8uKJ,\u0006\u000fZ1uK\"A\u00111\b\u0001!\u0002\u0013\t\u0019#\u0001\tjg\u000e{WO\u001c;feV\u0003H-\u0019;fA!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011E\u0001\u001cG>tG/Y5og\u000e{G\u000e\\3di&|gNQ3iCZLwN]:\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003G\tAdY8oi\u0006Lgn]\"pY2,7\r^5p]\n+\u0007.\u0019<j_J\u001c\b\u0005\u0003\u0006\u0002H\u0001\u0011\r\u0011\"\u0001\u0005\u0003C\tA\"[:JI\u0016l\u0007o\u001c;f]RD\u0001\"a\u0013\u0001A\u0003%\u00111E\u0001\u000eSNLE-Z7q_R,g\u000e\u001e\u0011\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R\u0005\u0001\u0002O]3qCJ,7\u000b^1uK6,g\u000e\u001e\u000b\u0007\u0003'\n\u0019'a\u001a\u0011\t\u0005U\u0013qL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005!1m\u001c:f\u0015\r\ti\u0006C\u0001\u0007IJLg/\u001a:\n\t\u0005\u0005\u0014q\u000b\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\bbBA3\u0003\u001b\u0002\r\u0001W\u0001\u000ecV,'/\u001f+f[Bd\u0017\r^3\t\u0011\u0005%\u0014Q\na\u0001\u0003W\nqa]3tg&|g\u000e\u0005\u0003\u0002V\u00055\u0014\u0002BA8\u0003/\u0012qaU3tg&|g\u000eC\u0004\u0002t\u0001!\t!!\u001e\u0002\u001f\t\fGo\u00195S_V$\u0018N\\4LKf$b!a\u001e\u0002\u0004\u0006\u0015Ec\u0001#\u0002z!A\u00111PA9\u0001\u0004\ti(\u0001\u0002cgB!\u0011QKA@\u0013\u0011\t\t)a\u0016\u0003\u001d\t{WO\u001c3Ti\u0006$X-\\3oi\"A\u0011\u0011NA9\u0001\u0004\tY\u0007\u0003\u0005\u0002\b\u0006E\u0004\u0019AAE\u0003M\u0011x.\u001e;j]\u001e\\U-_$f]\u0016\u0014\u0018\r^8s!\rI\u00141R\u0005\u0004\u0003\u001b\u0013!a\u0005*pkRLgnZ&fs\u001e+g.\u001a:bi>\u0014\bbBAI\u0001\u0011\u0005\u00111S\u0001\u0006oJLG/\u001a\u000b\u0007\u0003+\u000bY*!-\u0011\u0007A\t9*C\u0002\u0002\u001aF\u0011A!\u00168ji\"A\u0011QTAH\u0001\u0004\ty*A\u0006uCN\\7i\u001c8uKb$\b\u0003BAQ\u0003[k!!a)\u000b\u0007\u001d\t)K\u0003\u0003\u0002(\u0006%\u0016AB1qC\u000eDWM\u0003\u0002\u0002,\u0006\u0019qN]4\n\t\u0005=\u00161\u0015\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000f\u0003\u0005\u00024\u0006=\u0005\u0019AA[\u0003\u0011!\u0017\r^1\u0011\t5\n9\fP\u0005\u0004\u0003ss#\u0001C%uKJ\fGo\u001c:\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\u00061Q\u000f\u001d3bi\u0016$b!!&\u0002B\u0006\r\u0007\u0002CAO\u0003w\u0003\r!a(\t\u0011\u0005M\u00161\u0018a\u0001\u0003kCq!a2\u0001\t\u0003\tI-\u0001\u0004j]N,'\u000f\u001e\u000b\u0007\u0003+\u000bY-!4\t\u0011\u0005u\u0015Q\u0019a\u0001\u0003?C\u0001\"a-\u0002F\u0002\u0007\u0011Q\u0017\u0005\b\u0003#\u0004A\u0011AAj\u0003\u0019!W\r\\3uKR!\u0011Q[An)\u0019\t)*a6\u0002Z\"A\u0011QTAh\u0001\u0004\ty\n\u0003\u0005\u00024\u0006=\u0007\u0019AA[\u0011\u0019q\u0017q\u001aa\u0001\u007f\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005\u0018!D<sSR,\u0017J\u001c;fe:\fG\u000e\u0006\u0005\u0002\u0016\u0006\r\u0018Q]At\u0011\u001d\t)'!8A\u0002aC\u0001\"!(\u0002^\u0002\u0007\u0011q\u0014\u0005\t\u0003g\u000bi\u000e1\u0001\u00026\u001e9\u00111\u001e\u0002\t\u0002\u00055\u0018a\u0003+bE2,wK]5uKJ\u00042!OAx\r\u0019\t!\u0001#\u0001\u0002rN!\u0011q^\b\u0016\u0011\u001di\u0015q\u001eC\u0001\u0003k$\"!!<\t\u0011\u0005e\u0018q\u001eC\u0005\u0003w\f1c\u00195fG.l\u0015n]:j]\u001e\u001cu\u000e\\;n]N$b!!&\u0002~\n\u0005\u0001bBA\u0000\u0003o\u0004\raJ\u0001\u0006i\u0006\u0014G.\u001a\u0005\u0007M\u0006]\b\u0019\u00015\t\u0011\t\u0015\u0011q\u001eC\u0005\u0005\u000f\tQd\u00195fG.l\u0015n]:j]\u001e\u0004&/[7bef\\U-_\"pYVlgn\u001d\u000b\u0007\u0003+\u0013IAa\u0003\t\u000f\u0005}(1\u0001a\u0001O!1aMa\u0001A\u0002!D\u0001Ba\u0004\u0002p\u0012%!\u0011C\u0001 G\",7m['jgNLgn\u001a)beRLG/[8o\u0017\u0016L8i\u001c7v[:\u001cHCBAK\u0005'\u0011)\u0002C\u0004\u0002\u0000\n5\u0001\u0019A\u0014\t\r\u0019\u0014i\u00011\u0001i\u0011!\u0011I\"a<\u0005\n\tm\u0011!G8oYf\u0004\u0016M\u001d;ji&|gnS3z\u0003:$7\u000b^1uS\u000e$b!a\t\u0003\u001e\t}\u0001bBA\u0000\u0005/\u0001\ra\n\u0005\u0007M\n]\u0001\u0019\u00015\t\u0011\t\r\u0012q\u001eC\u0005\u0005K\t\u0001d\u00195fG.\u001cu\u000e\u001c7fGRLwN\u001c\"fQ\u00064\u0018n\u001c:t)\u0019\t)Ja\n\u0003*!9\u0011q B\u0011\u0001\u00049\u0003b\u0002B\u0016\u0005C\u0001\r\u0001L\u0001\u000bG>dW/\u001c8SK\u001a\u001c\b\u0002\u0003B\u0018\u0003_$IA!\r\u0002\u0019\rDWmY6D_2,XN\\:\u0015\u0011\u0005U%1\u0007B\u001b\u0005oAq!a@\u0003.\u0001\u0007q\u0005C\u0004\u0003,\t5\u0002\u0019\u0001\u0017\t\u0011\te\"Q\u0006a\u0001\u0003G\t\u0011c\u00195fG.\u0004\u0016M\u001d;ji&|gnS3z\u0011!\u0011i$a<\u0005\u0002\t}\u0012!B1qa2LX\u0003\u0002B!\u0005\u0013\"bBa\u0011\u0003V\t]#\u0011\fB.\u0005;\u0012y\u0006\u0006\u0003\u0003F\t-\u0003\u0003B\u001d\u0001\u0005\u000f\u00022!\u0010B%\t\u0019y$1\bb\u0001\u0001\"Q!Q\nB\u001e\u0003\u0003\u0005\u001dAa\u0014\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0003:\u0005#\u00129%C\u0002\u0003T\t\u0011\u0001CU8x/JLG/\u001a:GC\u000e$xN]=\t\r\u0015\u0011Y\u00041\u0001 \u0011\u00191&1\ba\u00011\"1!Ma\u000fA\u0002aCaA\u001aB\u001e\u0001\u0004y\bB\u0002%\u0003<\u0001\u0007\u0011\n\u0003\u0006\u0003:\tm\u0002\u0013!a\u0001\u0003GA!Ba\u0019\u0002pF\u0005I\u0011\u0001B3\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u00122T\u0003\u0002B4\u0005{*\"A!\u001b+\t\u0005\r\"1N\u0016\u0003\u0005[\u0002BAa\u001c\u0003z5\u0011!\u0011\u000f\u0006\u0005\u0005g\u0012)(A\u0005v]\u000eDWmY6fI*\u0019!qO\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003|\tE$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121qH!\u0019C\u0002\u0001C!B!!\u0002p\u0006\u0005I\u0011\u0002BB\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0005\u0003\u0002BD\u0005#k!A!#\u000b\t\t-%QR\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u0010\u0006!!.\u0019<b\u0013\u0011\u0011\u0019J!#\u0003\r=\u0013'.Z2u\u0001")
public class TableWriter<T>
implements Serializable,
Logging {
    private final CassandraConnector connector;
    public final TableDef com$datastax$spark$connector$writer$TableWriter$$tableDef;
    private final IndexedSeq<ColumnRef> columnSelector;
    public final RowWriter<T> com$datastax$spark$connector$writer$TableWriter$$rowWriter;
    public final WriteConf com$datastax$spark$connector$writer$TableWriter$$writeConf;
    private final String keyspaceName;
    private final String tableName;
    private final Seq<String> columnNames;
    private final Seq<ColumnDef> columns;
    private String queryTemplateUsingInsert;
    private String queryTemplateUsingUpdate;
    private Option<String> timestampSpec;
    private boolean ttlEnabled;
    private String optionsSpec;
    private final boolean com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate;
    private final boolean containsCollectionBehaviors;
    private final boolean isIdempotent;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile byte bitmap$0;

    public static <T> boolean apply$default$6() {
        return TableWriter$.MODULE$.apply$default$6();
    }

    public static <T> TableWriter<T> apply(CassandraConnector cassandraConnector, String string, String string2, ColumnSelector columnSelector, WriteConf writeConf, boolean bl, RowWriterFactory<T> rowWriterFactory) {
        return TableWriter$.MODULE$.apply(cassandraConnector, string, string2, columnSelector, writeConf, bl, rowWriterFactory);
    }

    private String queryTemplateUsingInsert$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq quotedColumnNames2 = (Seq)this.columnNames().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String name) {
                        return Quote$.MODULE$.quote(name);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String columnSpec = quotedColumnNames2.mkString(", ");
                String valueSpec = ((TraversableOnce)quotedColumnNames2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$1) {
                        return new StringBuilder().append((Object)":").append((Object)x$1).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String ifNotExistsSpec = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.ifNotExists() ? "IF NOT EXISTS " : "";
                this.queryTemplateUsingInsert = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", ".", " (", ") VALUES (", ") ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), columnSpec, valueSpec, ifNotExistsSpec, this.optionsSpec()})).trim();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.queryTemplateUsingInsert;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String queryTemplateUsingUpdate$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Tuple2 tuple23 = this.columns().partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ColumnDef x$6) {
                        return x$6.isPrimaryKeyColumn();
                    }
                });
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                Seq primaryKey = (Seq)tuple23._1();
                Seq regularColumns = (Seq)tuple23._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
                Seq primaryKey2 = (Seq)tuple24._1();
                Seq regularColumns2 = (Seq)tuple24._2();
                Tuple2 tuple25 = regularColumns2.partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ColumnDef x$8) {
                        return x$8.isCounterColumn();
                    }
                });
                if (tuple25 == null) throw new MatchError((Object)tuple25);
                Seq counterColumns = (Seq)tuple25._1();
                Seq nonCounterColumns = (Seq)tuple25._2();
                Tuple2 tuple26 = tuple2 = new Tuple2((Object)counterColumns, (Object)nonCounterColumns);
                Seq counterColumns2 = (Seq)tuple26._1();
                Seq nonCounterColumns2 = (Seq)tuple26._2();
                Map nameToBehavior = ((TraversableOnce)this.columnSelector.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof CollectionColumnName) {
                            CollectionColumnName collectionColumnName = (CollectionColumnName)A1;
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)collectionColumnName.columnName()), (Object)collectionColumnName.collectionBehavior());
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(ColumnRef x1) {
                        ColumnRef columnRef = x1;
                        boolean bl = columnRef instanceof CollectionColumnName;
                        return bl;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Seq setNonCounterColumnsClause = (Seq)((TraversableLike)nonCounterColumns2.map((Function1)new Serializable(this, nameToBehavior){
                    public static final long serialVersionUID = 0L;
                    private final Map nameToBehavior$1;

                    public final Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> apply(ColumnDef colDef) {
                        String name = colDef.columnName();
                        Option collectionBehavior = this.nameToBehavior$1.get((Object)name);
                        String quotedName = Quote$.MODULE$.quote(name);
                        return new Tuple4((Object)colDef, (Object)name, (Object)collectionBehavior, (Object)quotedName);
                    }
                    {
                        this.nameToBehavior$1 = nameToBehavior$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> x$10) {
                        Tuple4<ColumnDef, String, Option<CollectionBehavior>, String> tuple4;
                        block2: {
                            Option option;
                            block7: {
                                String string;
                                block4: {
                                    Some some;
                                    CollectionBehavior collectionBehavior;
                                    String quotedName;
                                    block6: {
                                        CollectionBehavior collectionBehavior2;
                                        Some some2;
                                        boolean bl;
                                        block5: {
                                            CollectionBehavior collectionBehavior3;
                                            block3: {
                                                tuple4 = x$10;
                                                if (tuple4 == null) break block2;
                                                Option collectionBehavior4 = (Option)tuple4._3();
                                                quotedName = (String)tuple4._4();
                                                bl = false;
                                                some2 = null;
                                                option = collectionBehavior4;
                                                if (!(option instanceof Some)) break block3;
                                                bl = true;
                                                some2 = (Some)option;
                                                CollectionBehavior collectionBehavior5 = (CollectionBehavior)some2.x();
                                                if (!CollectionAppend$.MODULE$.equals(collectionBehavior5)) break block3;
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " + :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                                break block4;
                                            }
                                            if (!bl || !CollectionPrepend$.MODULE$.equals(collectionBehavior3 = (CollectionBehavior)some2.x())) break block5;
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", " + ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                            break block4;
                                        }
                                        if (!bl || !CollectionRemove$.MODULE$.equals(collectionBehavior2 = (CollectionBehavior)some2.x())) break block6;
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " - :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName, quotedName}));
                                        break block4;
                                    }
                                    boolean bl = option instanceof Some && CollectionOverwrite$.MODULE$.equals(collectionBehavior = (CollectionBehavior)(some = (Some)option).x()) ? true : None$.MODULE$.equals(option);
                                    if (!bl) break block7;
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedName, quotedName}));
                                }
                                String string2 = string;
                                return string2;
                            }
                            throw new MatchError((Object)option);
                        }
                        throw new MatchError(tuple4);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq setCounterColumnsClause = (Seq)this.quotedColumnNames$2(counterColumns2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", " + :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                String setClause = ((TraversableOnce)setNonCounterColumnsClause.$plus$plus((GenTraversableOnce)setCounterColumnsClause, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String whereClause2 = ((TraversableOnce)this.quotedColumnNames$2(primaryKey2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
                this.queryTemplateUsingUpdate = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE ", ".", " ", " SET ", " WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), this.optionsSpec(), setClause, whereClause2}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.queryTemplateUsingUpdate;
        }
    }

    private Option timestampSpec$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                WriteOptionValue<Object> writeOptionValue;
                None$ none$;
                WriteOptionValue<Object> writeOptionValue2;
                TimestampOption timestampOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.timestamp();
                if (timestampOption != null && (writeOptionValue2 = timestampOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue2;
                    String placeholder2 = perRowWriteOptionValue.placeholder();
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeholder2})));
                } else if (timestampOption != null && (writeOptionValue = timestampOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue;
                    long value2 = BoxesRunTime.unboxToLong(staticWriteOptionValue.value());
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TIMESTAMP ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)value2)})));
                } else {
                    none$ = None$.MODULE$;
                }
                this.timestampSpec = none$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.timestampSpec;
        }
    }

    private boolean ttlEnabled$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                TTLOption tTLOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.ttl();
                TTLOption tTLOption2 = TTLOption$.MODULE$.defaultValue();
                this.ttlEnabled = tTLOption != null ? !((Object)tTLOption).equals(tTLOption2) : tTLOption2 != null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.ttlEnabled;
        }
    }

    private String optionsSpec$lzycompute() {
        TableWriter tableWriter = this;
        synchronized (tableWriter) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                WriteOptionValue<Object> writeOptionValue;
                None$ none$;
                WriteOptionValue<Object> writeOptionValue2;
                TTLOption tTLOption = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.ttl();
                if (tTLOption != null && (writeOptionValue2 = tTLOption.value()) instanceof PerRowWriteOptionValue) {
                    PerRowWriteOptionValue perRowWriteOptionValue = (PerRowWriteOptionValue)writeOptionValue2;
                    String placeholder2 = perRowWriteOptionValue.placeholder();
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{placeholder2})));
                } else if (tTLOption != null && (writeOptionValue = tTLOption.value()) instanceof StaticWriteOptionValue) {
                    StaticWriteOptionValue staticWriteOptionValue = (StaticWriteOptionValue)writeOptionValue;
                    int value2 = BoxesRunTime.unboxToInt(staticWriteOptionValue.value());
                    none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TTL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)value2)})));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ ttlSpec = none$;
                List options = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{ttlSpec, this.timestampSpec()})).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<String> apply(Option<String> xo) {
                        return Option$.MODULE$.option2Iterable(xo);
                    }
                });
                this.optionsSpec = options.nonEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USING ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.mkString(" AND ")})) : "";
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.optionsSpec;
        }
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    @TraitSetter
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String keyspaceName() {
        return this.keyspaceName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public Seq<ColumnDef> columns() {
        return this.columns;
    }

    public String queryTemplateUsingInsert() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.queryTemplateUsingInsert$lzycompute() : this.queryTemplateUsingInsert;
    }

    private String deleteQueryTemplate(ColumnSelector deleteColumns) {
        Seq deleteColumnNames = (Seq)deleteColumns.selectFrom(this.com$datastax$spark$connector$writer$TableWriter$$tableDef).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$2) {
                return x$2.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = this.columns().partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnDef x$3) {
                return x$3.isPrimaryKeyColumn();
            }
        });
        if (tuple2 != null) {
            String usingTimestampClause;
            Tuple2 tuple22;
            Seq primaryKey = (Seq)tuple2._1();
            Seq regularColumns = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)primaryKey, (Object)regularColumns);
            Seq primaryKey2 = (Seq)tuple23._1();
            Seq regularColumns2 = (Seq)tuple23._2();
            if (regularColumns2.nonEmpty()) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only primary key columns can be used in delete. Regular columns found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{regularColumns2.mkString(", ")})));
            }
            TableWriter$.MODULE$.com$datastax$spark$connector$writer$TableWriter$$checkMissingColumns(this.com$datastax$spark$connector$writer$TableWriter$$tableDef, (Seq<String>)deleteColumnNames);
            String deleteColumnsClause = ((TraversableOnce)deleteColumnNames.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String name) {
                    return Quote$.MODULE$.quote(name);
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
            String whereClause2 = ((TraversableOnce)this.quotedColumnNames$1(primaryKey2).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String c) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, c}));
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
            String string = usingTimestampClause = this.timestampSpec().nonEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USING ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestampSpec().get()})) : "";
            if (this.ttlEnabled()) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TableWriter $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is ignored for DELETE query"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.ttl()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE ", " FROM ", ".", " ", " WHERE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deleteColumnsClause, Quote$.MODULE$.quote(this.keyspaceName()), Quote$.MODULE$.quote(this.tableName()), usingTimestampClause, whereClause2}));
        }
        throw new MatchError((Object)tuple2);
    }

    public String queryTemplateUsingUpdate() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.queryTemplateUsingUpdate$lzycompute() : this.queryTemplateUsingUpdate;
    }

    private Option<String> timestampSpec() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.timestampSpec$lzycompute() : this.timestampSpec;
    }

    private boolean ttlEnabled() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.ttlEnabled$lzycompute() : this.ttlEnabled;
    }

    private String optionsSpec() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.optionsSpec$lzycompute() : this.optionsSpec;
    }

    public boolean com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() {
        return this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate;
    }

    private boolean containsCollectionBehaviors() {
        return this.containsCollectionBehaviors;
    }

    public boolean isIdempotent() {
        return this.isIdempotent;
    }

    public PreparedStatement com$datastax$spark$connector$writer$TableWriter$$prepareStatement(String queryTemplate, Session session) {
        try {
            return session.prepare(queryTemplate).setIdempotent(Predef$.MODULE$.boolean2Boolean(this.isIdempotent()));
        }
        catch (Throwable throwable) {
            throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to prepare statement ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryTemplate}))).append((Object)throwable.getMessage()).toString(), throwable);
        }
    }

    public Object batchRoutingKey(Session session, RoutingKeyGenerator routingKeyGenerator, BoundStatement bs) {
        BatchGroupingKey batchGroupingKey;
        block5: {
            Comparable<Integer> comparable;
            block3: {
                block4: {
                    block2: {
                        batchGroupingKey = this.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchGroupingKey();
                        if (!BatchGroupingKey$None$.MODULE$.equals(batchGroupingKey)) break block2;
                        comparable = BoxesRunTime.boxToInteger((int)0);
                        break block3;
                    }
                    if (!BatchGroupingKey$ReplicaSet$.MODULE$.equals(batchGroupingKey)) break block4;
                    Object object = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE) == null ? bs.setRoutingKey(routingKeyGenerator.apply(bs)) : BoxedUnit.UNIT;
                    comparable = BoxesRunTime.boxToInteger((int)((Object)session.getCluster().getMetadata().getReplicas(this.keyspaceName(), bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE))).hashCode());
                    break block3;
                }
                if (!BatchGroupingKey$Partition$.MODULE$.equals(batchGroupingKey)) break block5;
                Object object = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE) == null ? bs.setRoutingKey(routingKeyGenerator.apply(bs)) : BoxedUnit.UNIT;
                comparable = bs.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, CodecRegistry.DEFAULT_INSTANCE).duplicate();
            }
            return comparable;
        }
        throw new MatchError((Object)batchGroupingKey);
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        if (this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() || this.containsCollectionBehaviors()) {
            this.update(taskContext, data);
        } else {
            this.insert(taskContext, data);
        }
    }

    public void update(TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.queryTemplateUsingUpdate(), taskContext, data);
    }

    public void insert(TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.queryTemplateUsingInsert(), taskContext, data);
    }

    public void delete(ColumnSelector columns, TaskContext taskContext, Iterator<T> data) {
        this.writeInternal(this.deleteQueryTemplate(columns), taskContext, data);
    }

    private void writeInternal(String queryTemplate, TaskContext taskContext, Iterator<T> data) {
        OutputMetricsUpdater updater = OutputMetricsUpdater$.MODULE$.apply(taskContext, this.com$datastax$spark$connector$writer$TableWriter$$writeConf);
        this.connector.withSessionDo(new Serializable(this, queryTemplate, data, updater){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;
            private final String queryTemplate$1;
            private final Iterator data$1;
            public final OutputMetricsUpdater updater$1;

            public final void apply(Session session) {
                ProtocolVersion protocolVersion2 = session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
                CountingIterator<T> rowIterator = new CountingIterator<T>(this.data$1, CountingIterator$.MODULE$.$lessinit$greater$default$2());
                PreparedStatement stmt = this.$outer.com$datastax$spark$connector$writer$TableWriter$$prepareStatement(this.queryTemplate$1, session).setConsistencyLevel(this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.consistencyLevel());
                QueryExecutor queryExecutor = new QueryExecutor(session, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.parallelismLevel(), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                    public final void apply(RichStatement x$15, long x$16, long x$17) {
                        this.$outer.updater$1.batchFinished(true, x$15, x$16, x$17);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }), (Option<Function3<RichStatement, Object, Object, BoxedUnit>>)new Some((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                    public final void apply(RichStatement x$18, long x$19, long x$20) {
                        this.$outer.updater$1.batchFinished(false, x$18, x$19, x$20);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                RoutingKeyGenerator routingKeyGenerator = new RoutingKeyGenerator(this.$outer.com$datastax$spark$connector$writer$TableWriter$$tableDef, this.$outer.columnNames());
                BatchStatement.Type batchType = this.$outer.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate() ? BatchStatement.Type.COUNTER : BatchStatement.Type.UNLOGGED;
                RowWriter<T> x$33 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$rowWriter;
                PreparedStatement x$34 = stmt;
                ProtocolVersion x$35 = protocolVersion2;
                boolean x$36 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.ignoreNulls();
                Seq<Object> x$37 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$3();
                BoundStatementBuilder<T> boundStmtBuilder = new BoundStatementBuilder<T>(x$33, x$34, x$37, x$36, x$35);
                BatchStatementBuilder batchStmtBuilder = new BatchStatementBuilder(batchType, routingKeyGenerator, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.consistencyLevel());
                Serializable batchKeyGenerator = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeInternal$1 $outer;
                    private final RoutingKeyGenerator routingKeyGenerator$1;
                    private final Session session$1;

                    public final Object apply(BoundStatement bs) {
                        return this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().batchRoutingKey(this.session$1, this.routingKeyGenerator$1, bs);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.routingKeyGenerator$1 = routingKeyGenerator$1;
                        this.session$1 = session$1;
                    }
                };
                GroupingBatchBuilder<T> batchBuilder = new GroupingBatchBuilder<T>(boundStmtBuilder, batchStmtBuilder, (Function1<BoundStatement, Object>)batchKeyGenerator, this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchSize(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.batchGroupingBufferSize(), rowIterator);
                RateLimiter rateLimiter = new RateLimiter((long)(this.$outer.com$datastax$spark$connector$writer$TableWriter$$writeConf.throughputMiBPS() * (double)1024 * (double)1024), 0x100000L, RateLimiter$.MODULE$.$lessinit$greater$default$3(), RateLimiter$.MODULE$.$lessinit$greater$default$4());
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing data partition to ", ".", " in batches of ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().com$datastax$spark$connector$writer$TableWriter$$writeConf.batchSize()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                batchBuilder.foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final QueryExecutor queryExecutor$1;
                    private final RateLimiter rateLimiter$1;

                    public final void apply(RichStatement stmtToWrite) {
                        this.queryExecutor$1.executeAsync(stmtToWrite);
                        Predef$.MODULE$.assert(stmtToWrite.bytesCount() > 0);
                        this.rateLimiter$1.maybeSleep(stmtToWrite.bytesCount());
                    }
                    {
                        this.queryExecutor$1 = queryExecutor$1;
                        this.rateLimiter$1 = rateLimiter$1;
                    }
                });
                queryExecutor.waitForCurrentlyExecutingTasks();
                queryExecutor.getLatestException().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeInternal$1 $outer;

                    public final Nothing$ apply(Throwable x0$2) {
                        Throwable throwable = x0$2;
                        throw new IOException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write statements to ", ".", ". The\n               |latest exception was\n               |  ", "\n               |\n               |Please check the executor logs for more exceptions and information\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName(), this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName(), throwable.getMessage()})))).stripMargin());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                double duration = (double)this.updater$1.finish() / 1.0E9;
                this.$outer.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeInternal$1 $outer;
                    private final CountingIterator rowIterator$1;
                    private final double duration$1;

                    public final String apply() {
                        Integer arg$macro$11 = BoxesRunTime.boxToInteger((int)this.rowIterator$1.count());
                        String arg$macro$12 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().keyspaceName();
                        String arg$macro$13 = this.$outer.com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer().tableName();
                        double arg$macro$14 = this.duration$1;
                        return new StringOps("Wrote %s rows to %s.%s in %.3f s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$11, arg$macro$12, arg$macro$13, BoxesRunTime.boxToDouble((double)arg$macro$14)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.rowIterator$1 = rowIterator$1;
                        this.duration$1 = duration$1;
                    }
                });
                if (boundStmtBuilder.logUnsetToNullWarning()) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this, boundStmtBuilder){
                        public static final long serialVersionUID = 0L;
                        private final BoundStatementBuilder boundStmtBuilder$1;

                        public final String apply() {
                            return this.boundStmtBuilder$1.UnsetToNullWarning();
                        }
                        {
                            this.boundStmtBuilder$1 = boundStmtBuilder$1;
                        }
                    });
                }
            }

            public /* synthetic */ TableWriter com$datastax$spark$connector$writer$TableWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queryTemplate$1 = queryTemplate$1;
                this.data$1 = var3_3;
                this.updater$1 = var4_4;
            }
        });
    }

    private final Seq quotedColumnNames$1(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$5) {
                return x$5.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return Quote$.MODULE$.quote(name);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq quotedColumnNames$2(Seq columns) {
        return (Seq)((TraversableLike)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$11) {
                return x$11.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return Quote$.MODULE$.quote(name);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public TableWriter(CassandraConnector connector, TableDef tableDef, IndexedSeq<ColumnRef> columnSelector, RowWriter<T> rowWriter, WriteConf writeConf) {
        this.connector = connector;
        this.com$datastax$spark$connector$writer$TableWriter$$tableDef = tableDef;
        this.columnSelector = columnSelector;
        this.com$datastax$spark$connector$writer$TableWriter$$rowWriter = rowWriter;
        this.com$datastax$spark$connector$writer$TableWriter$$writeConf = writeConf;
        Logging$class.$init$(this);
        Predef$.MODULE$.require(!tableDef.isView(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is a Materialized View and Views are not writable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$writer$TableWriter$$tableDef.name()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.keyspaceName = tableDef.keyspaceName();
        this.tableName = tableDef.tableName();
        this.columnNames = (Seq)rowWriter.columnNames().diff(writeConf.optionPlaceholders());
        this.columns = (Seq)this.columnNames().map(tableDef.columnByName(), Seq$.MODULE$.canBuildFrom());
        this.com$datastax$spark$connector$writer$TableWriter$$isCounterUpdate = tableDef.columns().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnDef x$12) {
                return x$12.isCounterColumn();
            }
        });
        this.containsCollectionBehaviors = columnSelector.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnRef x$13) {
                return x$13 instanceof CollectionColumnName;
            }
        });
        this.isIdempotent = ((TraversableOnce)this.columns().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnDef x$14) {
                return x$14.isCounterColumn();
            }
        })).nonEmpty() ? false : columnSelector.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableWriter $outer;

            public final boolean apply(ColumnRef x0$1) {
                ColumnRef columnRef;
                block4: {
                    boolean bl;
                    block3: {
                        block2: {
                            columnRef = x0$1;
                            if (!(columnRef instanceof CollectionColumnName)) break block2;
                            CollectionColumnName collectionColumnName = (CollectionColumnName)columnRef;
                            String name = collectionColumnName.columnName();
                            CollectionBehavior behavior = collectionColumnName.collectionBehavior();
                            boolean isNotList = !(((ColumnDef)this.$outer.com$datastax$spark$connector$writer$TableWriter$$tableDef.columnByName().apply((Object)name)).columnType() instanceof ListType);
                            CollectionBehavior collectionBehavior = behavior;
                            boolean bl2 = CollectionPrepend$.MODULE$.equals(collectionBehavior) ? isNotList : (CollectionAppend$.MODULE$.equals(collectionBehavior) ? isNotList : true);
                            bl = bl2;
                            break block3;
                        }
                        if (columnRef == null) break block4;
                        bl = true;
                    }
                    return bl;
                }
                throw new MatchError((Object)columnRef);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

