/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants;

import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jnr.constants.Constant;
import jnr.constants.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantSet
extends AbstractSet<Constant> {
    private final Map<String, Constant> nameToConstant;
    private final Map<Long, Constant> valueToConstant;
    private final Set<Enum> constants;
    private final Class<Enum> enumClass;
    private volatile Long minValue;
    private volatile Long maxValue;
    private static final ConcurrentMap<String, ConstantSet> constantSets = new ConcurrentHashMap<String, ConstantSet>();
    private static final Object lock = new Object();

    public static ConstantSet getConstantSet(String name) {
        ConstantSet constants = (ConstantSet)constantSets.get(name);
        return constants != null ? constants : ConstantSet.loadConstantSet(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConstantSet loadConstantSet(String name) {
        Object object = lock;
        synchronized (object) {
            ConstantSet constants = (ConstantSet)constantSets.get(name);
            if (constants == null) {
                Class<Enum> enumClass = ConstantSet.getEnumClass(name);
                if (enumClass == null) {
                    return null;
                }
                if (!Constant.class.isAssignableFrom(enumClass)) {
                    throw new ClassCastException("class for " + name + " does not implement Constant interface");
                }
                constants = new ConstantSet(enumClass);
                constantSets.put(name, constants);
            }
            return constants;
        }
    }

    private static final Class<Enum> getEnumClass(String name) {
        String[] prefixes;
        for (String prefix : prefixes = Platform.getPlatform().getPackagePrefixes()) {
            try {
                return Class.forName(prefix + "." + name).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException ex) {
            }
        }
        return null;
    }

    private ConstantSet(Class<Enum> enumClass) {
        this.enumClass = enumClass;
        this.constants = EnumSet.allOf(enumClass);
        HashMap<String, Constant> names = new HashMap<String, Constant>();
        HashMap<Long, Constant> values = new HashMap<Long, Constant>();
        for (Enum e : this.constants) {
            if (!(e instanceof Constant)) continue;
            Constant c = (Constant)((Object)e);
            names.put(e.name(), c);
            values.put(c.longValue(), c);
        }
        this.nameToConstant = Collections.unmodifiableMap(names);
        this.valueToConstant = Collections.unmodifiableMap(values);
    }

    public final Constant getConstant(String name) {
        return this.nameToConstant.get(name);
    }

    public Constant getConstant(long value2) {
        return this.valueToConstant.get(value2);
    }

    public long getValue(String name) {
        Constant c = this.getConstant(name);
        return c != null ? c.longValue() : 0L;
    }

    public String getName(int value2) {
        Constant c = this.getConstant(value2);
        return c != null ? c.name() : "unknown";
    }

    private Long getLongField(String name, long defaultValue) {
        try {
            Field f = this.enumClass.getField(name);
            return (Long)f.get(this.enumClass);
        }
        catch (NoSuchFieldException ex) {
            return defaultValue;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public long minValue() {
        if (this.minValue == null) {
            this.minValue = this.getLongField("MIN_VALUE", Integer.MIN_VALUE);
        }
        return this.minValue.intValue();
    }

    public long maxValue() {
        if (this.maxValue == null) {
            this.maxValue = this.getLongField("MAX_VALUE", Integer.MAX_VALUE);
        }
        return this.maxValue.intValue();
    }

    @Override
    public Iterator<Constant> iterator() {
        return new ConstantIterator(this.constants);
    }

    @Override
    public int size() {
        return this.constants.size();
    }

    @Override
    public boolean contains(Object o) {
        return o != null && o.getClass().equals(this.enumClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConstantIterator
    implements Iterator<Constant> {
        private final Iterator<Enum> it;
        private Constant next = null;

        ConstantIterator(Collection<Enum> constants) {
            this.it = constants.iterator();
            this.next = this.it.hasNext() ? (Constant)((Object)this.it.next()) : null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && !this.next.name().equals("__UNKNOWN_CONSTANT__");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Constant next() {
            Constant prev = this.next;
            this.next = this.it.hasNext() ? (Constant)((Object)this.it.next()) : null;
            return prev;
        }
    }
}

