/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.google.common.eventbus;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import shade.com.datastax.spark.connector.google.common.base.Objects;
import shade.com.datastax.spark.connector.google.common.base.Throwables;
import shade.com.datastax.spark.connector.google.common.cache.CacheBuilder;
import shade.com.datastax.spark.connector.google.common.cache.CacheLoader;
import shade.com.datastax.spark.connector.google.common.cache.LoadingCache;
import shade.com.datastax.spark.connector.google.common.collect.HashMultimap;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableList;
import shade.com.datastax.spark.connector.google.common.collect.Maps;
import shade.com.datastax.spark.connector.google.common.collect.Multimap;
import shade.com.datastax.spark.connector.google.common.eventbus.AllowConcurrentEvents;
import shade.com.datastax.spark.connector.google.common.eventbus.EventSubscriber;
import shade.com.datastax.spark.connector.google.common.eventbus.Subscribe;
import shade.com.datastax.spark.connector.google.common.eventbus.SubscriberFindingStrategy;
import shade.com.datastax.spark.connector.google.common.eventbus.SynchronizedEventSubscriber;
import shade.com.datastax.spark.connector.google.common.reflect.TypeToken;
import shade.com.datastax.spark.connector.google.common.util.concurrent.UncheckedExecutionException;

class AnnotatedSubscriberFinder
implements SubscriberFindingStrategy {
    private static final LoadingCache<Class<?>, ImmutableList<Method>> subscriberMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableList<Method>>(){

        @Override
        public ImmutableList<Method> load(Class<?> concreteClass) throws Exception {
            return AnnotatedSubscriberFinder.getAnnotatedMethodsInternal(concreteClass);
        }
    });

    AnnotatedSubscriberFinder() {
    }

    @Override
    public Multimap<Class<?>, EventSubscriber> findAllSubscribers(Object listener) {
        HashMultimap<Class<?>, EventSubscriber> methodsInListener = HashMultimap.create();
        Class<?> clazz = listener.getClass();
        for (Method method2 : AnnotatedSubscriberFinder.getAnnotatedMethods(clazz)) {
            Class<?>[] parameterTypes = method2.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            EventSubscriber subscriber = AnnotatedSubscriberFinder.makeSubscriber(listener, method2);
            methodsInListener.put(eventType, subscriber);
        }
        return methodsInListener;
    }

    private static ImmutableList<Method> getAnnotatedMethods(Class<?> clazz) {
        try {
            return subscriberMethodsCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    private static ImmutableList<Method> getAnnotatedMethodsInternal(Class<?> clazz) {
        Set supers = TypeToken.of(clazz).getTypes().rawTypes();
        HashMap<MethodIdentifier, Method> identifiers = Maps.newHashMap();
        for (Class superClazz : supers) {
            for (Method superClazzMethod : superClazz.getMethods()) {
                if (!superClazzMethod.isAnnotationPresent(Subscribe.class) || superClazzMethod.isBridge()) continue;
                Class<?>[] parameterTypes = superClazzMethod.getParameterTypes();
                if (parameterTypes.length != 1) {
                    String string = String.valueOf(String.valueOf(superClazzMethod));
                    int n = parameterTypes.length;
                    throw new IllegalArgumentException(new StringBuilder(128 + string.length()).append("Method ").append(string).append(" has @Subscribe annotation, but requires ").append(n).append(" arguments.  Event subscriber methods must require a single argument.").toString());
                }
                MethodIdentifier ident = new MethodIdentifier(superClazzMethod);
                if (identifiers.containsKey(ident)) continue;
                identifiers.put(ident, superClazzMethod);
            }
        }
        return ImmutableList.copyOf(identifiers.values());
    }

    private static EventSubscriber makeSubscriber(Object listener, Method method2) {
        EventSubscriber wrapper = AnnotatedSubscriberFinder.methodIsDeclaredThreadSafe(method2) ? new EventSubscriber(listener, method2) : new SynchronizedEventSubscriber(listener, method2);
        return wrapper;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method2) {
        return method2.getAnnotation(AllowConcurrentEvents.class) != null;
    }

    private static final class MethodIdentifier {
        private final String name;
        private final List<Class<?>> parameterTypes;

        MethodIdentifier(Method method2) {
            this.name = method2.getName();
            this.parameterTypes = Arrays.asList(method2.getParameterTypes());
        }

        public int hashCode() {
            return Objects.hashCode(this.name, this.parameterTypes);
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof MethodIdentifier) {
                MethodIdentifier ident = (MethodIdentifier)o;
                return this.name.equals(ident.name) && this.parameterTypes.equals(ident.parameterTypes);
            }
            return false;
        }
    }
}

