/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet;

import com.datatorrent.netlet.EventLoop;
import com.datatorrent.netlet.Listener;
import com.datatorrent.netlet.NetletThrowable;
import com.datatorrent.netlet.util.CircularBuffer;
import com.datatorrent.netlet.util.Slice;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements Listener.ClientListener {
    private static final int THROWABLES_COLLECTION_SIZE = 4;
    public static final int MAX_SENDBUFFER_SIZE;
    private static final SelectionKey invalidSelectionKey;
    protected final CircularBuffer<NetletThrowable> throwables;
    protected final CircularBuffer<CircularBuffer<Slice>> bufferOfBuffers;
    protected final CircularBuffer<Slice> freeBuffer;
    protected CircularBuffer<Slice> sendBuffer4Offers;
    protected CircularBuffer<Slice> sendBuffer4Polls;
    protected final ByteBuffer writeBuffer;
    protected boolean write = true;
    protected SelectionKey key = invalidSelectionKey;
    private static final Logger logger;

    public boolean isConnected() {
        return this.key.isValid() && ((SocketChannel)this.key.channel()).isConnected();
    }

    public AbstractClient(int writeBufferSize, int sendBufferSize) {
        this(ByteBuffer.allocateDirect(writeBufferSize), sendBufferSize);
    }

    public AbstractClient(int sendBufferSize) {
        this(8192, sendBufferSize);
    }

    public AbstractClient() {
        this(8192, 1024);
    }

    public AbstractClient(ByteBuffer writeBuffer, int sendBufferSize) {
        int i = 1;
        int n = 1;
        do {
            ++i;
        } while ((n *= 2) != MAX_SENDBUFFER_SIZE);
        this.bufferOfBuffers = new CircularBuffer(i);
        this.throwables = new CircularBuffer(4);
        this.writeBuffer = writeBuffer;
        if (sendBufferSize == 0) {
            sendBufferSize = 1024;
        } else if (sendBufferSize % 1024 > 0) {
            sendBufferSize += 1024 - sendBufferSize % 1024;
        }
        this.sendBuffer4Offers = new CircularBuffer(sendBufferSize, 10);
        this.sendBuffer4Polls = this.sendBuffer4Offers;
        this.freeBuffer = new CircularBuffer(sendBufferSize, 10);
    }

    @Override
    public void registered(SelectionKey key) {
        this.key = key;
    }

    @Override
    public void connected() {
        this.write = false;
    }

    @Override
    public void disconnected() {
        this.write = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void read() throws IOException {
        SocketChannel channel = (SocketChannel)this.key.channel();
        int read = channel.read(this.buffer());
        if (read > 0) {
            this.read(read);
        } else if (read == -1) {
            try {
                channel.close();
            }
            finally {
                this.disconnected();
                this.unregistered(this.key);
                this.key.attach(Listener.NOOP_CLIENT_LISTENER);
            }
        } else {
            logger.debug("{} read 0 bytes", (Object)this);
        }
    }

    public boolean isReadSuspended() {
        return (this.key.interestOps() & 1) == 0;
    }

    public boolean suspendReadIfResumed() {
        int interestOps = this.key.interestOps();
        if ((interestOps & 1) == 1) {
            logger.debug("Suspending read on key {} with attachment {}", (Object)this.key, this.key.attachment());
            this.key.interestOps(interestOps & 0xFFFFFFFE);
            return true;
        }
        return false;
    }

    public boolean resumeReadIfSuspended() {
        int interestOps = this.key.interestOps();
        if ((interestOps & 1) == 0) {
            logger.debug("Resuming read on key {} with attachment {}", (Object)this.key, this.key.attachment());
            this.key.interestOps(interestOps | 1);
            this.key.selector().wakeup();
            return true;
        }
        return false;
    }

    @Deprecated
    public void suspendRead() {
        this.key.interestOps(this.key.interestOps() & 0xFFFFFFFE);
    }

    @Deprecated
    public void resumeRead() {
        this.key.interestOps(this.key.interestOps() | 1);
        this.key.selector().wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write() throws IOException {
        int remaining;
        int size = this.sendBuffer4Polls.size();
        if (size > 0 && (remaining = this.writeBuffer.remaining()) > 0) {
            do {
                Slice f = this.sendBuffer4Polls.peekUnsafe();
                if (remaining < f.length) {
                    this.writeBuffer.put(f.buffer, f.offset, remaining);
                    f.offset += remaining;
                    f.length -= remaining;
                    break;
                }
                this.writeBuffer.put(f.buffer, f.offset, f.length);
                remaining -= f.length;
                this.freeBuffer.offer(this.sendBuffer4Polls.pollUnsafe());
            } while (--size > 0);
        }
        this.writeBuffer.flip();
        SocketChannel channel = (SocketChannel)this.key.channel();
        while ((remaining = this.writeBuffer.remaining()) > 0) {
            if ((remaining -= channel.write(this.writeBuffer)) > 0) {
                this.writeBuffer.compact();
                return;
            }
            if (size <= 0) continue;
            this.writeBuffer.clear();
            remaining = this.writeBuffer.capacity();
            do {
                Slice f = this.sendBuffer4Polls.peekUnsafe();
                if (remaining < f.length) {
                    this.writeBuffer.put(f.buffer, f.offset, remaining);
                    f.offset += remaining;
                    f.length -= remaining;
                    break;
                }
                this.writeBuffer.put(f.buffer, f.offset, f.length);
                remaining -= f.length;
                this.freeBuffer.offer(this.sendBuffer4Polls.pollUnsafe());
            } while (--size > 0);
            this.writeBuffer.flip();
        }
        this.writeBuffer.clear();
        CircularBuffer<CircularBuffer<Slice>> circularBuffer = this.bufferOfBuffers;
        synchronized (circularBuffer) {
            if (this.sendBuffer4Polls.isEmpty()) {
                if (this.sendBuffer4Offers == this.sendBuffer4Polls) {
                    this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
                    this.write = false;
                } else {
                    this.sendBuffer4Polls = this.bufferOfBuffers.isEmpty() ? this.sendBuffer4Offers : this.bufferOfBuffers.pollUnsafe();
                }
            }
        }
    }

    public boolean send(byte[] array) {
        return this.send(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(byte[] array, int offset, int len) {
        Slice f;
        if (!this.throwables.isEmpty()) {
            NetletThrowable.Util.throwRuntime(this.throwables.pollUnsafe());
        }
        if (this.freeBuffer.isEmpty()) {
            f = new Slice(array, offset, len);
        } else {
            f = this.freeBuffer.pollUnsafe();
            f.buffer = array;
            f.offset = offset;
            f.length = len;
        }
        if (this.sendBuffer4Offers.offer(f)) {
            CircularBuffer<CircularBuffer<Slice>> circularBuffer = this.bufferOfBuffers;
            synchronized (circularBuffer) {
                if (!this.write) {
                    this.key.interestOps(this.key.interestOps() | 4);
                    this.write = true;
                    this.key.selector().wakeup();
                }
            }
            return true;
        }
        if (!this.throwables.isEmpty()) {
            NetletThrowable.Util.throwRuntime(this.throwables.pollUnsafe());
        }
        if (this.sendBuffer4Offers.capacity() != MAX_SENDBUFFER_SIZE) {
            CircularBuffer<CircularBuffer<Slice>> circularBuffer = this.bufferOfBuffers;
            synchronized (circularBuffer) {
                if (this.sendBuffer4Offers != this.sendBuffer4Polls) {
                    this.bufferOfBuffers.add(this.sendBuffer4Offers);
                }
                this.sendBuffer4Offers = new CircularBuffer(this.sendBuffer4Offers.capacity() << 1);
                this.sendBuffer4Offers.add(f);
                if (!this.write) {
                    this.key.interestOps(this.key.interestOps() | 4);
                    this.write = true;
                    this.key.selector().wakeup();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void handleException(Exception cce, EventLoop el) {
        logger.error("Exception in event loop {}", (Object)el, (Object)cce);
        this.throwables.offer(NetletThrowable.Util.rewrap(cce, el));
    }

    public abstract ByteBuffer buffer();

    public abstract void read(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregistered(SelectionKey key) {
        CircularBuffer<CircularBuffer<Slice>> circularBuffer = this.bufferOfBuffers;
        synchronized (circularBuffer) {
            final CircularBuffer<Slice> SEND_BUFFER = this.sendBuffer4Offers;
            this.sendBuffer4Offers = new CircularBuffer<Slice>(0){

                @Override
                public boolean isEmpty() {
                    return SEND_BUFFER.isEmpty();
                }

                @Override
                public boolean offer(Slice e) {
                    throw new NetletThrowable.NetletRuntimeException(new UnsupportedOperationException("Client does not own the socket any longer!"), null);
                }

                @Override
                public int size() {
                    return SEND_BUFFER.size();
                }

                @Override
                public Slice pollUnsafe() {
                    return (Slice)SEND_BUFFER.pollUnsafe();
                }

                @Override
                public Slice peekUnsafe() {
                    return (Slice)SEND_BUFFER.peekUnsafe();
                }
            };
        }
    }

    static {
        invalidSelectionKey = new SelectionKey(){

            @Override
            public SelectableChannel channel() {
                return null;
            }

            @Override
            public Selector selector() {
                return null;
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public void cancel() {
            }

            @Override
            public int interestOps() {
                return 0;
            }

            @Override
            public SelectionKey interestOps(int ops) {
                return this;
            }

            @Override
            public int readyOps() {
                return 0;
            }
        };
        logger = LoggerFactory.getLogger(AbstractClient.class);
        int size = 32768;
        String key = "NETLET.MAX_SENDBUFFER_SIZE";
        String property = System.getProperty("NETLET.MAX_SENDBUFFER_SIZE");
        if (property != null) {
            try {
                size = Integer.parseInt(property);
                if (size <= 0) {
                    throw new IllegalArgumentException("NETLET.MAX_SENDBUFFER_SIZE needs to be a positive integer which is also power of 2.");
                }
                if ((size & size - 1) != 0) {
                    --size;
                    size |= size >> 1;
                    size |= size >> 2;
                    size |= size >> 4;
                    size |= size >> 8;
                    size |= size >> 16;
                    logger.warn("{} set to {} since {} is not power of 2.", new Object[]{"NETLET.MAX_SENDBUFFER_SIZE", ++size, property});
                }
            }
            catch (Exception exception) {
                logger.warn("{} set to {} since {} could not be parsed as an integer.", new Object[]{"NETLET.MAX_SENDBUFFER_SIZE", size, property, exception});
            }
        }
        MAX_SENDBUFFER_SIZE = size;
    }
}

