/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet;

import com.datatorrent.netlet.EventLoop;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Listener {
    public static final Listener NOOP_LISTENER = new Listener(){

        @Override
        public void handleException(Exception cce, EventLoop el) {
        }

        @Override
        public void registered(SelectionKey key) {
        }

        @Override
        public void unregistered(SelectionKey key) {
        }
    };
    public static final Listener NOOP_CLIENT_LISTENER = new ClientListener(){

        @Override
        public void read() throws IOException {
        }

        @Override
        public void write() throws IOException {
        }

        @Override
        public void handleException(Exception cce, EventLoop el) {
        }

        @Override
        public void registered(SelectionKey key) {
        }

        @Override
        public void unregistered(SelectionKey key) {
        }

        @Override
        public void connected() {
        }

        @Override
        public void disconnected() {
        }
    };

    public void handleException(Exception var1, EventLoop var2);

    public void registered(SelectionKey var1);

    public void unregistered(SelectionKey var1);

    public static class DisconnectingListener
    implements ClientListener {
        private final ClientListener previous;
        private final SelectionKey key;
        private static final Logger logger = LoggerFactory.getLogger(DisconnectingListener.class);

        public DisconnectingListener(SelectionKey key) {
            this.key = key;
            this.previous = (ClientListener)key.attachment();
        }

        @Override
        public void read() throws IOException {
            this.disconnect();
        }

        private void disconnect() {
            if (!this.key.isValid() || (this.key.interestOps() & 4) == 0) {
                this.previous.disconnected();
                this.key.attach(null);
                try {
                    this.key.channel().close();
                }
                catch (IOException ie) {
                    logger.warn("exception while closing socket", (Throwable)ie);
                }
            }
        }

        @Override
        public void write() throws IOException {
            try {
                this.previous.write();
            }
            catch (IOException ex) {
                this.key.cancel();
                throw ex;
            }
            catch (RuntimeException re) {
                this.key.cancel();
                throw re;
            }
            finally {
                this.disconnect();
            }
        }

        @Override
        public void handleException(Exception cce, EventLoop el) {
            this.previous.handleException(cce, el);
        }

        @Override
        public void registered(SelectionKey key) {
        }

        @Override
        public void unregistered(SelectionKey key) {
        }

        @Override
        public void connected() {
        }

        @Override
        public void disconnected() {
        }
    }

    public static interface ClientListener
    extends Listener {
        public void read() throws IOException;

        public void write() throws IOException;

        public void connected();

        public void disconnected();
    }

    public static interface ServerListener
    extends Listener {
        public ClientListener getClientConnection(SocketChannel var1, ServerSocketChannel var2);
    }
}

