/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet.util;

import java.io.Serializable;
import java.util.Arrays;
import org.getopt.util.hash.MurmurHash;

public class Slice
implements Serializable,
Cloneable {
    public byte[] buffer;
    public int offset;
    public int length;
    private static final long serialVersionUID = 201311151835L;

    private Slice() {
    }

    public Slice(byte[] array, int offset, int length) {
        this.buffer = array;
        this.offset = offset;
        this.length = length;
    }

    public Slice(byte[] array) {
        this.buffer = array;
        this.offset = 0;
        this.length = array.length;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + MurmurHash.hash(this.buffer, hash, this.offset, this.length);
        hash = 59 * hash + this.offset;
        hash = 59 * hash + this.length;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Slice other = (Slice)obj;
        if (this.length != other.length) {
            return false;
        }
        int offset1 = this.offset;
        byte[] buffer1 = this.buffer;
        int i = offset1 + this.length;
        byte[] buffer2 = other.buffer;
        int j = other.offset + other.length;
        while (i-- > offset1) {
            if (buffer1[i] == buffer2[--j]) continue;
            return false;
        }
        return true;
    }

    public Slice clone() throws CloneNotSupportedException {
        Slice clone = (Slice)super.clone();
        clone.buffer = (byte[])this.buffer.clone();
        return clone;
    }

    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.buffer, this.offset, this.offset + this.length);
    }

    public String stringValue() {
        return new String(this.buffer, this.offset, this.length);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + (this.length > 256 ? "buffer=" + this.buffer + ", offset=" + this.offset + ", length=" + this.length : Arrays.toString(Arrays.copyOfRange(this.buffer, this.offset, this.offset + this.length))) + '}';
    }
}

