/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet.util;

import com.datatorrent.netlet.util.UnsafeBlockingQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedCircularBuffer<T>
implements UnsafeBlockingQueue<T> {
    private static final Logger logger = LoggerFactory.getLogger(SynchronizedCircularBuffer.class);
    private final T[] buffer;
    private final int buffermask;
    private long tail;
    private long head;
    private final int spinMillis;

    public SynchronizedCircularBuffer(int n, int spin) {
        int i;
        for (i = 1; i < n; i <<= 1) {
        }
        this.buffer = new Object[i];
        this.buffermask = i - 1;
        this.spinMillis = spin;
    }

    public SynchronizedCircularBuffer(int n) {
        this(n, 10);
    }

    @Override
    public synchronized boolean add(T toAdd) {
        if (this.head - this.tail <= (long)this.buffermask) {
            this.buffer[(int)(this.head++ & (long)this.buffermask)] = toAdd;
            return true;
        }
        throw new IllegalStateException("Collection is full");
    }

    @Override
    public synchronized T remove() {
        if (this.head > this.tail) {
            return this.buffer[(int)(this.tail++ & (long)this.buffermask)];
        }
        throw new IllegalStateException("Collection is empty");
    }

    @Override
    public synchronized T peek() {
        if (this.head > this.tail) {
            return this.buffer[(int)(this.tail & (long)this.buffermask)];
        }
        return null;
    }

    @Override
    public final synchronized int size() {
        return (int)(this.head - this.tail);
    }

    public int capacity() {
        return this.buffermask + 1;
    }

    @Override
    public synchronized int drainTo(Collection<? super T> container) {
        int size = this.size();
        while (this.head > this.tail) {
            container.add(this.buffer[(int)(this.tail++ & (long)this.buffermask)]);
        }
        return size;
    }

    public synchronized String toString() {
        return "head=" + this.head + ", tail=" + this.tail + ", capacity=" + (this.buffermask + 1);
    }

    @Override
    public final synchronized boolean offer(T e) {
        if (this.head - this.tail <= (long)this.buffermask) {
            this.buffer[(int)(this.head++ & (long)this.buffermask)] = e;
            return true;
        }
        return false;
    }

    @Override
    public final synchronized void put(T e) throws InterruptedException {
        while (true) {
            if (this.head - this.tail < (long)this.buffermask) {
                this.buffer[(int)(this.head++ & (long)this.buffermask)] = e;
                return;
            }
            this.wait(this.spinMillis);
        }
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public T take() throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int remainingCapacity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final synchronized T poll() {
        if (this.head > this.tail) {
            return this.buffer[(int)(this.tail++ & (long)this.buffermask)];
        }
        return null;
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final synchronized T pollUnsafe() {
        return this.buffer[(int)(this.tail++ & (long)this.buffermask)];
    }

    @Override
    public final synchronized T peekUnsafe() {
        return this.buffer[(int)(this.tail & (long)this.buffermask)];
    }
}

