/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.Iterator;
import java.util.List;
import java.util.regex.MatchResult;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.server.internal.ServerTraceEvent;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.Route;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.uri.PathPattern;

class PathPatternRouter
implements Router {
    private final List<Route<PathPattern>> acceptedRoutes;

    PathPatternRouter(List<Route<PathPattern>> routes) {
        this.acceptedRoutes = routes;
    }

    @Override
    public Router.Continuation apply(RequestProcessingContext context) {
        RoutingContext rc = context.routingContext();
        String path = rc.getFinalMatchingGroup();
        TracingLogger tracingLogger = TracingLogger.getInstance(context.request());
        tracingLogger.log(ServerTraceEvent.MATCH_PATH_FIND, path);
        Router.Continuation result = null;
        Iterator<Route<PathPattern>> iterator = this.acceptedRoutes.iterator();
        while (iterator.hasNext()) {
            Route<PathPattern> acceptedRoute = iterator.next();
            PathPattern routePattern = acceptedRoute.routingPattern();
            MatchResult m = routePattern.match(path);
            if (m != null) {
                rc.pushMatchResult(m);
                result = Router.Continuation.of(context, acceptedRoute.next());
                tracingLogger.log(ServerTraceEvent.MATCH_PATH_SELECTED, routePattern.getRegex());
                break;
            }
            tracingLogger.log(ServerTraceEvent.MATCH_PATH_NOT_MATCHED, routePattern.getRegex());
        }
        if (tracingLogger.isLogEnabled(ServerTraceEvent.MATCH_PATH_SKIPPED)) {
            while (iterator.hasNext()) {
                tracingLogger.log(ServerTraceEvent.MATCH_PATH_SKIPPED, iterator.next().routingPattern().getRegex());
            }
        }
        if (result == null) {
            result = Router.Continuation.of(context);
        }
        return result;
    }
}

