/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.AbstractRequest;
import com.bradmcevoy.http.AbstractResponse;
import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.Cookie;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.Filter;
import com.bradmcevoy.http.FilterChain;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.RequestParseException;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.io.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DebugFilter.class);
    private static int counter = 0;
    private File logDir;

    public DebugFilter() {
        this.logDir = new File(System.getProperty("java.io.tmpdir"));
        log.info("DebugFilter is logging requests to: " + this.logDir.getAbsolutePath());
    }

    public DebugFilter(File logDir) {
        this.logDir = logDir;
        log.info("DebugFilter is logging requests to: " + logDir.getAbsolutePath());
    }

    @Override
    public void process(FilterChain chain, Request request, Response response) {
        try {
            DebugRequest req2 = new DebugRequest(request);
            DebugResponse resp2 = new DebugResponse(response);
            chain.process(req2, resp2);
            this.record(req2, resp2);
            response.getOutputStream().write(resp2.out.toByteArray());
            response.getOutputStream().flush();
        }
        catch (IOException ex) {
            log.error("", (Throwable)ex);
        }
    }

    private synchronized void record(DebugRequest req2, DebugResponse resp2) {
        File f;
        ++counter;
        FileOutputStream fout = null;
        try {
            f = new File(this.logDir, counter + "_" + (Object)((Object)req2.getMethod()) + ".req");
            fout = new FileOutputStream(f);
            req2.record(fout);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                StreamUtils.close(fout);
                throw throwable;
            }
        }
        StreamUtils.close(fout);
        try {
            f = resp2.getStatus() != null ? new File(this.logDir, counter + "_" + resp2.getStatus().code + ".resp") : new File(this.logDir, counter + "_UNKNOWN" + ".resp");
            fout = new FileOutputStream(f);
            resp2.record(fout);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            StreamUtils.close(fout);
        }
    }

    public class DebugRequest
    extends AbstractRequest {
        final Request r;
        final byte[] contentBytes;
        final ByteArrayInputStream content;

        public DebugRequest(Request r) {
            this.r = r;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                StreamUtils.readTo(r.getInputStream(), (OutputStream)out);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.contentBytes = out.toByteArray();
            this.content = new ByteArrayInputStream(this.contentBytes);
            log.debug(out.toString());
        }

        @Override
        public Map<String, String> getHeaders() {
            return this.r.getHeaders();
        }

        @Override
        public String getRequestHeader(Request.Header header) {
            return this.r.getRequestHeader(header);
        }

        @Override
        public String getFromAddress() {
            return this.r.getFromAddress();
        }

        @Override
        public Request.Method getMethod() {
            return this.r.getMethod();
        }

        @Override
        public Auth getAuthorization() {
            return this.r.getAuthorization();
        }

        @Override
        public void setAuthorization(Auth auth) {
            this.r.setAuthorization(auth);
        }

        @Override
        public String getAbsoluteUrl() {
            return this.r.getAbsoluteUrl();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.content;
        }

        @Override
        public void parseRequestParameters(Map<String, String> params, Map<String, FileItem> files) throws RequestParseException {
            this.r.parseRequestParameters(params, files);
        }

        public void record(OutputStream out) {
            PrintWriter writer = new PrintWriter(out);
            writer.println((Object)((Object)this.getMethod()) + " " + this.getAbsolutePath() + " HTTP/1.1");
            for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
                writer.println(header.getKey() + ": " + header.getValue());
            }
            writer.flush();
            try {
                out.write(this.contentBytes);
            }
            catch (IOException ex) {
                log.error("", (Throwable)ex);
            }
        }

        @Override
        public Cookie getCookie(String name) {
            return this.r.getCookie(name);
        }

        @Override
        public List<Cookie> getCookies() {
            return this.r.getCookies();
        }

        @Override
        public String getRemoteAddr() {
            return this.r.getRemoteAddr();
        }
    }

    public class DebugResponse
    extends AbstractResponse {
        final Response r;
        final ByteArrayOutputStream out;
        List<String> challenges;

        public DebugResponse(Response r) {
            this.r = r;
            this.out = new ByteArrayOutputStream();
        }

        @Override
        public Response.Status getStatus() {
            return this.r.getStatus();
        }

        @Override
        public void setStatus(Response.Status status) {
            this.r.setStatus(status);
        }

        @Override
        public void setNonStandardHeader(String code, String value) {
            this.r.setNonStandardHeader(code, value);
        }

        @Override
        public String getNonStandardHeader(String code) {
            return this.r.getNonStandardHeader(code);
        }

        @Override
        public OutputStream getOutputStream() {
            return this.out;
        }

        @Override
        public Map<String, String> getHeaders() {
            return this.r.getHeaders();
        }

        private void record(FileOutputStream fout) {
            try {
                PrintWriter writer = new PrintWriter(fout);
                if (this.getStatus() != null) {
                    writer.println("HTTP/1.1 " + this.getStatus().code);
                }
                for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
                    writer.println(header.getKey() + ": " + header.getValue());
                }
                if (this.challenges != null) {
                    for (String ch : this.challenges) {
                        writer.println((Object)((Object)Response.Header.WWW_AUTHENTICATE) + ": " + ch);
                    }
                }
                writer.flush();
                log.debug(this.out.toString());
                fout.write(this.out.toByteArray());
                fout.flush();
            }
            catch (IOException ex) {
                log.error("", (Throwable)ex);
            }
        }

        @Override
        public void setAuthenticateHeader(List<String> challenges) {
            this.challenges = challenges;
            this.r.setAuthenticateHeader(challenges);
        }

        @Override
        public Cookie setCookie(Cookie cookie) {
            return this.r.setCookie(cookie);
        }

        @Override
        public Cookie setCookie(String name, String value) {
            return this.r.setCookie(name, value);
        }
    }
}

