/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11.auth;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.AuthenticationHandler;
import com.bradmcevoy.http.DigestResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.http11.auth.DigestHelper;
import com.bradmcevoy.http.http11.auth.DigestResponse;
import com.bradmcevoy.http.http11.auth.NonceProvider;
import com.bradmcevoy.http.http11.auth.SimpleMemoryNonceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestAuthenticationHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(DigestAuthenticationHandler.class);
    private final NonceProvider nonceProvider;
    private final DigestHelper digestHelper;

    public DigestAuthenticationHandler(NonceProvider nonceProvider) {
        this.nonceProvider = nonceProvider;
        this.digestHelper = new DigestHelper(nonceProvider);
    }

    public DigestAuthenticationHandler() {
        this.nonceProvider = new SimpleMemoryNonceProvider(86400);
        this.digestHelper = new DigestHelper(this.nonceProvider);
    }

    @Override
    public boolean supports(Resource r, Request request) {
        boolean b;
        Auth auth = request.getAuthorization();
        if (auth == null) {
            return false;
        }
        if (r instanceof DigestResource) {
            DigestResource dr = (DigestResource)r;
            if (dr.isDigestAllowed()) {
                b = Auth.Scheme.DIGEST.equals((Object)auth.getScheme());
            } else {
                log.trace("digest auth is not allowed");
                b = false;
            }
        } else {
            log.trace("resource is not an instanceof DigestResource");
            b = false;
        }
        return b;
    }

    @Override
    public Object authenticate(Resource r, Request request) {
        DigestResource digestResource = (DigestResource)r;
        Auth auth = request.getAuthorization();
        DigestResponse resp = this.digestHelper.calculateResponse(auth, r.getRealm(), request.getMethod());
        if (resp == null) {
            log.debug("requested digest authentication is invalid or incorrectly formatted");
            return null;
        }
        Object o = digestResource.authenticate(resp);
        return o;
    }

    @Override
    public String getChallenge(Resource resource, Request request) {
        String nonceValue = this.nonceProvider.createNonce(resource, request);
        return this.digestHelper.getChallenge(nonceValue, request.getAuthorization(), resource.getRealm());
    }

    @Override
    public boolean isCompatible(Resource resource) {
        if (resource instanceof DigestResource) {
            DigestResource dr = (DigestResource)resource;
            return dr.isDigestAllowed();
        }
        return false;
    }
}

