/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.values;

import com.bradmcevoy.http.XmlWriter;
import com.bradmcevoy.http.values.BooleanValueWriter;
import com.bradmcevoy.http.values.CDataValueWriter;
import com.bradmcevoy.http.values.DateValueWriter;
import com.bradmcevoy.http.values.HrefListValueWriter;
import com.bradmcevoy.http.values.LockTokenValueWriter;
import com.bradmcevoy.http.values.ModifiedDateValueWriter;
import com.bradmcevoy.http.values.ResourceTypeValueWriter;
import com.bradmcevoy.http.values.SupportedLockValueWriter;
import com.bradmcevoy.http.values.SupportedReportSetWriter;
import com.bradmcevoy.http.values.ToStringValueWriter;
import com.bradmcevoy.http.values.UUIDValueWriter;
import com.bradmcevoy.http.values.ValueAndType;
import com.bradmcevoy.http.values.ValueWriter;
import com.bradmcevoy.http.values.WrappedHrefWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueWriters {
    private static final Logger log = LoggerFactory.getLogger(ValueWriters.class);
    private final List<ValueWriter> writers;

    public ValueWriters(List<ValueWriter> valueWriters) {
        this.writers = valueWriters;
    }

    public ValueWriters() {
        this.writers = new ArrayList<ValueWriter>();
        this.writers.add(new LockTokenValueWriter());
        this.writers.add(new SupportedLockValueWriter());
        this.writers.add(new ModifiedDateValueWriter());
        this.writers.add(new DateValueWriter());
        this.writers.add(new ResourceTypeValueWriter());
        this.writers.add(new BooleanValueWriter());
        this.writers.add(new CDataValueWriter());
        this.writers.add(new UUIDValueWriter());
        this.writers.add(new HrefListValueWriter());
        this.writers.add(new WrappedHrefWriter());
        this.writers.add(new SupportedReportSetWriter());
        this.writers.add(new ToStringValueWriter());
    }

    public void writeValue(XmlWriter writer, QName qname, String prefix, ValueAndType vat, String href, Map<String, String> nsPrefixes) {
        for (ValueWriter vw : this.writers) {
            if (!vw.supports(qname.getNamespaceURI(), qname.getLocalPart(), vat.getType())) continue;
            vw.writeValue(writer, qname.getNamespaceURI(), prefix, qname.getLocalPart(), vat.getValue(), href, nsPrefixes);
            break;
        }
    }

    public List<ValueWriter> getValueWriters() {
        return this.writers;
    }

    public Object parse(QName qname, Class valueType, String value) {
        for (ValueWriter vw : this.writers) {
            if (!vw.supports(qname.getNamespaceURI(), qname.getLocalPart(), valueType)) continue;
            log.trace("parse: Found supporting value writer {} ", (Object)vw);
            return vw.parse(qname.getNamespaceURI(), qname.getLocalPart(), value);
        }
        log.warn("parse: No value writer supports: qname: " + qname + " type:" + valueType + " value:" + value);
        return null;
    }
}

