/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.Utils;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.values.ValueAndType;
import com.bradmcevoy.http.webdav.PropFindRequestFieldParser;
import com.bradmcevoy.http.webdav.PropFindResponse;
import com.bradmcevoy.property.PropertySource;
import com.ettrema.common.LogUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropFindPropertyBuilder {
    private static final Logger log = LoggerFactory.getLogger(PropFindPropertyBuilder.class);
    private final List<PropertySource> propertySources;

    public PropFindPropertyBuilder(List<PropertySource> propertySources) {
        this.propertySources = propertySources;
        log.debug("num property sources: " + propertySources.size());
    }

    public List<PropFindResponse> buildProperties(PropFindableResource pfr, int depth, PropFindRequestFieldParser.ParseResult parseResult, String url) throws URISyntaxException {
        LogUtils.trace(log, "buildProperties: ", pfr.getClass());
        ArrayList<PropFindResponse> propFindResponses = new ArrayList<PropFindResponse>();
        this.appendResponses(propFindResponses, pfr, depth, parseResult, url);
        return propFindResponses;
    }

    public ValueAndType getProperty(QName field, Resource resource) throws NotAuthorizedException {
        log.debug("num property sources: " + this.propertySources.size());
        for (PropertySource source : this.propertySources) {
            PropertySource.PropertyMetaData meta = source.getPropertyMetaData(field, resource);
            if (meta == null || meta.isUnknown()) continue;
            Object val = source.getProperty(field, resource);
            return new ValueAndType(val, meta.getValueType());
        }
        return null;
    }

    private void appendResponses(List<PropFindResponse> responses, PropFindableResource resource, int requestedDepth, PropFindRequestFieldParser.ParseResult parseResult, String encodedCollectionUrl) throws URISyntaxException {
        String collectionHref = this.suffixSlash(resource, encodedCollectionUrl);
        URI parentUri = new URI(collectionHref);
        collectionHref = parentUri.toASCIIString();
        this.processResource(responses, resource, parseResult, collectionHref, requestedDepth, 0, collectionHref);
    }

    public void processResource(List<PropFindResponse> responses, PropFindableResource resource, PropFindRequestFieldParser.ParseResult parseResult, String href, int requestedDepth, int currentDepth, String collectionHref) {
        collectionHref = this.suffixSlash(resource, collectionHref);
        LinkedHashMap<QName, ValueAndType> knownProperties = new LinkedHashMap<QName, ValueAndType>();
        ArrayList<PropFindResponse.NameAndError> unknownProperties = new ArrayList<PropFindResponse.NameAndError>();
        if (resource instanceof CollectionResource && !href.endsWith("/")) {
            href = href + "/";
        }
        Set<QName> requestedFields = parseResult.isAllProp() ? this.findAllProps(resource) : parseResult.getNames();
        for (QName field : requestedFields) {
            LogUtils.trace(log, "processResource:", field);
            if (field.getLocalPart().equals("href")) {
                knownProperties.put(field, new ValueAndType(href, String.class));
                continue;
            }
            boolean found = false;
            for (PropertySource source : this.propertySources) {
                PropertySource.PropertyMetaData meta = source.getPropertyMetaData(field, resource);
                if (meta == null || meta.isUnknown()) continue;
                try {
                    Object object = source.getProperty(field, resource);
                    LogUtils.trace(log, "processResource: got value", object, "from source", source.getClass());
                    knownProperties.put(field, new ValueAndType(object, meta.getValueType()));
                }
                catch (NotAuthorizedException ex) {
                    unknownProperties.add(new PropFindResponse.NameAndError(field, "Not authorised"));
                }
                found = true;
                break;
            }
            if (found) continue;
            if (log.isDebugEnabled()) {
                log.debug("unknown: " + field.toString());
            }
            unknownProperties.add(new PropFindResponse.NameAndError(field, null));
        }
        if (log.isDebugEnabled() && unknownProperties.size() > 0) {
            log.debug("some properties could not be resolved. Listing property sources:");
            for (PropertySource ps : this.propertySources) {
                log.debug(" - " + ps.getClass().getCanonicalName());
            }
        }
        EnumMap<Response.Status, List<PropFindResponse.NameAndError>> errorProperties = new EnumMap<Response.Status, List<PropFindResponse.NameAndError>>(Response.Status.class);
        errorProperties.put(Response.Status.SC_NOT_FOUND, unknownProperties);
        PropFindResponse r = new PropFindResponse(href, knownProperties, errorProperties);
        responses.add(r);
        if (requestedDepth > currentDepth && resource instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)((Object)resource);
            List<? extends Resource> list = col.getChildren();
            list = new ArrayList<Resource>(list);
            for (Resource resource2 : list) {
                if (!(resource2 instanceof PropFindableResource)) continue;
                String childName = resource2.getName();
                if (childName == null) {
                    log.warn("null name for resource of type: " + resource2.getClass() + " in folder: " + href + " WILL NOT be returned in PROPFIND response!!");
                    continue;
                }
                String childHref = href + Utils.percentEncode(childName);
                this.processResource(responses, (PropFindableResource)resource2, parseResult, childHref, requestedDepth, currentDepth + 1, href);
            }
        }
    }

    private String suffixSlash(PropFindableResource resource, String s) {
        if (resource instanceof CollectionResource && !s.endsWith("/")) {
            s = s + "/";
        }
        return s;
    }

    public Set<QName> findAllProps(PropFindableResource resource) {
        LinkedHashSet<QName> names = new LinkedHashSet<QName>();
        for (PropertySource source : this.propertySources) {
            List<QName> allprops = source.getAllPropertyNames(resource);
            if (allprops == null) continue;
            names.addAll(allprops);
        }
        return names;
    }
}

