/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PropPatchSaxHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(PropPatchSaxHandler.class);
    private Stack<String> elementPath = new Stack();
    private Map<QName, String> attributesCurrent;
    private Map<QName, String> attributesSet = new LinkedHashMap<QName, String>();
    private Map<QName, String> attributesRemove = new LinkedHashMap<QName, String>();
    private StringBuilder sb = new StringBuilder();
    private boolean inProp;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.inProp) {
            this.sb.append("<" + localName + ">");
        }
        if (this.elementPath.size() > 0) {
            if (this.attributesCurrent != null) {
                if (this.elementPath.peek().endsWith("prop")) {
                    this.inProp = true;
                }
            } else {
                if (this.elementPath.peek().endsWith("set")) {
                    this.attributesCurrent = this.attributesSet;
                }
                if (this.elementPath.peek().endsWith("remove")) {
                    this.attributesCurrent = this.attributesRemove;
                }
            }
        }
        this.elementPath.push(localName);
        super.startElement(uri, localName, name, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inProp) {
            this.sb.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.elementPath.pop();
        if (this.elementPath.size() > 0) {
            if (this.elementPath.peek().endsWith("prop")) {
                if (this.sb != null) {
                    String s = this.sb.toString().trim();
                    QName qname = new QName(uri, localName);
                    this.attributesCurrent.put(qname, s);
                }
                this.sb = new StringBuilder();
            } else {
                if (this.inProp) {
                    this.sb.append("</" + localName + ">");
                }
                if (this.elementPath.peek().endsWith("set")) {
                    this.attributesCurrent = null;
                } else if (this.elementPath.peek().endsWith("remove")) {
                    this.attributesCurrent = null;
                }
            }
        }
        super.endElement(uri, localName, name);
    }

    public Map<QName, String> getAttributesToSet() {
        return this.attributesSet;
    }

    public Map<QName, String> getAttributesToRemove() {
        return this.attributesRemove;
    }
}

