/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.units;

import com.facebook.presto.jdbc.internal.airlift.units.Preconditions;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSize
implements Comparable<DataSize> {
    private static final Pattern PATTERN = Pattern.compile("^\\s*(\\d+(?:\\.\\d+)?)\\s*([a-zA-Z]+)\\s*$");
    private final double value;
    private final Unit unit;

    public static DataSize succinctBytes(long bytes) {
        return DataSize.succinctDataSize(bytes, Unit.BYTE);
    }

    public static DataSize succinctDataSize(double size, Unit unit) {
        return new DataSize(size, unit).convertToMostSuccinctDataSize();
    }

    public DataSize(double size, Unit unit) {
        Preconditions.checkArgument(!Double.isInfinite(size), "size is infinite");
        Preconditions.checkArgument(!Double.isNaN(size), "size is not a number");
        Preconditions.checkArgument(size >= 0.0, "size is negative");
        Objects.requireNonNull(unit, "unit is null");
        this.value = size;
        this.unit = unit;
    }

    public long toBytes() {
        double bytes = this.getValue(Unit.BYTE);
        Preconditions.checkState(bytes <= 9.223372036854776E18, "size is too large to be represented in bytes as a long");
        return (long)bytes;
    }

    public double getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public double getValue(Unit unit) {
        return this.value * ((double)this.unit.getFactor() * 1.0 / (double)unit.getFactor());
    }

    public long roundTo(Unit unit) {
        double rounded = Math.floor(this.getValue(unit) + 0.5);
        Preconditions.checkArgument(rounded <= 9.223372036854776E18, "size is too large to be represented in requested unit as a long");
        return (long)rounded;
    }

    public DataSize convertTo(Unit unit) {
        Objects.requireNonNull(unit, "unit is null");
        return new DataSize(this.getValue(unit), unit);
    }

    public DataSize convertToMostSuccinctDataSize() {
        Unit unitToUse = Unit.BYTE;
        for (Unit unitToTest : Unit.values()) {
            if (!(this.getValue(unitToTest) >= 1.0)) break;
            unitToUse = unitToTest;
        }
        return this.convertTo(unitToUse);
    }

    @JsonValue
    public String toString() {
        if (Math.floor(this.value) == this.value) {
            return (long)Math.floor(this.value) + this.unit.getUnitString();
        }
        return String.format(Locale.ENGLISH, "%.2f%s", this.value, this.unit.getUnitString());
    }

    @JsonCreator
    public static DataSize valueOf(String size) throws IllegalArgumentException {
        Objects.requireNonNull(size, "size is null");
        Preconditions.checkArgument(!size.isEmpty(), "size is empty");
        Matcher matcher = PATTERN.matcher(size);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("size is not a valid data size string: " + size);
        }
        double value = Double.parseDouble(matcher.group(1));
        String unitString = matcher.group(2);
        for (Unit unit : Unit.values()) {
            if (!unit.getUnitString().equals(unitString)) continue;
            return new DataSize(value, unit);
        }
        throw new IllegalArgumentException("Unknown unit: " + unitString);
    }

    @Override
    public int compareTo(DataSize o) {
        return Double.compare(this.getValue(Unit.BYTE), o.getValue(Unit.BYTE));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSize dataSize = (DataSize)o;
        return this.compareTo(dataSize) == 0;
    }

    public int hashCode() {
        double value = this.getValue(Unit.BYTE);
        return Double.hashCode(value);
    }

    public static enum Unit {
        BYTE(1L, "B"),
        KILOBYTE(1024L, "kB"),
        MEGABYTE(0x100000L, "MB"),
        GIGABYTE(0x40000000L, "GB"),
        TERABYTE(0x10000000000L, "TB"),
        PETABYTE(0x4000000000000L, "PB");

        private final long factor;
        private final String unitString;

        private Unit(long factor, String unitString) {
            this.factor = factor;
            this.unitString = unitString;
        }

        long getFactor() {
            return this.factor;
        }

        public String getUnitString() {
            return this.unitString;
        }
    }
}

