/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg;

import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import com.facebook.presto.jdbc.internal.joda.time.DateTimeZone;
import com.facebook.presto.jdbc.internal.joda.time.format.DateTimeFormatter;
import com.facebook.presto.jdbc.internal.joda.time.format.ISODateTimeFormat;
import com.facebook.presto.jdbc.internal.joda.time.format.ISOPeriodFormat;

public class FormatConfig {
    private static final DateTimeZone DEFAULT_TZ = DateTimeZone.getDefault();
    public static final JacksonJodaDateFormat DEFAULT_DATEONLY_FORMAT = FormatConfig.createUTC(ISODateTimeFormat.date());
    public static final JacksonJodaDateFormat DEFAULT_TIMEONLY_FORMAT = FormatConfig.createUTC(ISODateTimeFormat.time());
    public static final JacksonJodaDateFormat DEFAULT_DATETIME_PARSER = FormatConfig.createUTC(ISODateTimeFormat.dateTimeParser());
    public static final JacksonJodaDateFormat DEFAULT_DATETIME_PRINTER;
    @Deprecated
    public static final JacksonJodaDateFormat DEFAULT_DATETIME_FORMAT;
    public static final JacksonJodaDateFormat DEFAULT_LOCAL_DATEONLY_FORMAT;
    public static final JacksonJodaDateFormat DEFAULT_LOCAL_TIMEONLY_PRINTER;
    public static final JacksonJodaDateFormat DEFAULT_LOCAL_TIMEONLY_PARSER;
    public static final JacksonJodaDateFormat DEFAULT_LOCAL_DATETIME_PRINTER;
    public static final JacksonJodaDateFormat DEFAULT_LOCAL_DATETIME_PARSER;
    public static final JacksonJodaPeriodFormat DEFAULT_PERIOD_FORMAT;

    private static final JacksonJodaDateFormat createUTC(DateTimeFormatter f) {
        f = f.withZoneUTC();
        return new JacksonJodaDateFormat(f);
    }

    private static final JacksonJodaDateFormat createDefaultTZ(DateTimeFormatter f) {
        f = f.withZone(DEFAULT_TZ);
        return new JacksonJodaDateFormat(f);
    }

    static {
        DEFAULT_DATETIME_FORMAT = DEFAULT_DATETIME_PRINTER = FormatConfig.createUTC(ISODateTimeFormat.dateTime());
        DEFAULT_LOCAL_DATEONLY_FORMAT = FormatConfig.createDefaultTZ(ISODateTimeFormat.date());
        DEFAULT_LOCAL_TIMEONLY_PRINTER = FormatConfig.createDefaultTZ(ISODateTimeFormat.time());
        DEFAULT_LOCAL_TIMEONLY_PARSER = FormatConfig.createDefaultTZ(ISODateTimeFormat.localTimeParser());
        DEFAULT_LOCAL_DATETIME_PRINTER = FormatConfig.createDefaultTZ(ISODateTimeFormat.dateTime());
        DEFAULT_LOCAL_DATETIME_PARSER = FormatConfig.createDefaultTZ(ISODateTimeFormat.localDateOptionalTimeParser());
        DEFAULT_PERIOD_FORMAT = new JacksonJodaPeriodFormat(ISOPeriodFormat.standard());
    }
}

