/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.alpn.client;

import com.facebook.presto.jdbc.internal.jetty.alpn.client.ALPNClientConnection;
import com.facebook.presto.jdbc.internal.jetty.io.ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.io.Connection;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.NegotiatingClientConnectionFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;

public class ALPNClientConnectionFactory
extends NegotiatingClientConnectionFactory {
    private final Executor executor;
    private final List<String> protocols;

    public ALPNClientConnectionFactory(Executor executor, ClientConnectionFactory connectionFactory, List<String> protocols) {
        super(connectionFactory);
        this.executor = executor;
        this.protocols = protocols;
        if (protocols.isEmpty()) {
            throw new IllegalArgumentException("ALPN protocol list cannot be empty");
        }
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        ALPNClientConnection connection = new ALPNClientConnection(endPoint, this.executor, this.getClientConnectionFactory(), (SSLEngine)context.get("ssl.engine"), context, this.protocols);
        return this.customize(connection, context);
    }
}

