/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.Origin;
import com.facebook.presto.jdbc.internal.jetty.io.ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.util.HostPort;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProxyConfiguration {
    private final List<Proxy> proxies = new ArrayList<Proxy>();

    public List<Proxy> getProxies() {
        return this.proxies;
    }

    public Proxy match(Origin origin) {
        for (Proxy proxy : this.getProxies()) {
            if (!proxy.matches(origin)) continue;
            return proxy;
        }
        return null;
    }

    public static abstract class Proxy {
        private final Set<String> included = new HashSet<String>();
        private final Set<String> excluded = new HashSet<String>();
        private final Origin.Address address;
        private final boolean secure;

        protected Proxy(Origin.Address address, boolean secure) {
            this.address = address;
            this.secure = secure;
        }

        public Origin.Address getAddress() {
            return this.address;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public Set<String> getIncludedAddresses() {
            return this.included;
        }

        public Set<String> getExcludedAddresses() {
            return this.excluded;
        }

        public URI getURI() {
            return null;
        }

        public boolean matches(Origin origin) {
            if (this.getAddress().equals(origin.getAddress())) {
                return false;
            }
            boolean result = this.included.isEmpty();
            Origin.Address address = origin.getAddress();
            for (String included : this.included) {
                if (!this.matches(address, included)) continue;
                result = true;
                break;
            }
            for (String excluded : this.excluded) {
                if (!this.matches(address, excluded)) continue;
                result = false;
                break;
            }
            return result;
        }

        private boolean matches(Origin.Address address, String pattern) {
            HostPort hostPort = new HostPort(pattern);
            String host = hostPort.getHost();
            int port = hostPort.getPort();
            return host.equals(address.getHost()) && (port <= 0 || port == address.getPort());
        }

        public abstract ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory var1);

        public String toString() {
            return this.address.toString();
        }
    }
}

