/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.ByteArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.ByteArrayBlockEncoding;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ByteArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ByteArrayBlockBuilder.class).instanceSize() + BlockBuilderStatus.INSTANCE_SIZE;
    private BlockBuilderStatus blockBuilderStatus;
    private int positionCount;
    private boolean[] valueIsNull;
    private byte[] values;
    private int retainedSizeInBytes;

    public ByteArrayBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        this.values = new byte[expectedEntries];
        this.valueIsNull = new boolean[expectedEntries];
        this.updateDataSize();
    }

    @Override
    public BlockBuilder writeByte(int value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = (byte)value;
        ++this.positionCount;
        this.blockBuilderStatus.addBytes(2);
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        ++this.positionCount;
        this.blockBuilderStatus.addBytes(2);
        return this;
    }

    @Override
    public Block build() {
        return new ByteArrayBlock(this.positionCount, this.valueIsNull, this.values);
    }

    @Override
    public void reset(BlockBuilderStatus blockBuilderStatus) {
        this.blockBuilderStatus = Objects.requireNonNull(blockBuilderStatus, "blockBuilderStatus is null");
        int newSize = BlockUtil.calculateBlockResetSize(this.positionCount);
        this.valueIsNull = new boolean[newSize];
        this.values = new byte[newSize];
        this.positionCount = 0;
        this.updateDataSize();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        return new ByteArrayBlockBuilder(blockBuilderStatus, this.positionCount);
    }

    private void growCapacity() {
        int newSize = BlockUtil.calculateNewArraySize(this.values.length);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = BlockUtil.intSaturatedCast((long)INSTANCE_SIZE + SizeOf.sizeOf(this.valueIsNull) + SizeOf.sizeOf(this.values));
    }

    @Override
    public int getSizeInBytes() {
        return BlockUtil.intSaturatedCast(2L * (long)this.positionCount);
    }

    @Override
    public int getRegionSizeInBytes(int position, int length) {
        return BlockUtil.intSaturatedCast(2L * (long)length);
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public byte getByte(int position, int offset) {
        this.checkReadablePosition(position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be zero");
        }
        return this.values[position];
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull[position];
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeByte(this.values[position]);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        return new ByteArrayBlock(1, new boolean[]{this.valueIsNull[position]}, new byte[]{this.values[position]});
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        boolean[] newValueIsNull = new boolean[positions.size()];
        byte[] newValues = new byte[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            int position = positions.get(i);
            this.checkReadablePosition(position);
            newValueIsNull[i] = this.valueIsNull[position];
            newValues[i] = this.values[position];
        }
        return new ByteArrayBlock(positions.size(), newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new ByteArrayBlock(positionOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        byte[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new ByteArrayBlock(length, newValueIsNull, newValues);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new ByteArrayBlockEncoding();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

