/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import com.facebook.presto.jdbc.internal.spi.type.DateTimeEncoding;
import com.facebook.presto.jdbc.internal.spi.type.TimeZoneKey;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.TimeZone;

public final class SqlTimeWithTimeZone {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS VV");
    private final long millisUtc;
    private final TimeZoneKey timeZoneKey;

    public SqlTimeWithTimeZone(long timeWithTimeZone) {
        this.millisUtc = DateTimeEncoding.unpackMillisUtc(timeWithTimeZone);
        this.timeZoneKey = DateTimeEncoding.unpackZoneKey(timeWithTimeZone);
    }

    public SqlTimeWithTimeZone(long millisUtc, TimeZoneKey timeZoneKey) {
        this.millisUtc = millisUtc;
        this.timeZoneKey = timeZoneKey;
    }

    public SqlTimeWithTimeZone(long millisUtc, TimeZone timeZone) {
        this.millisUtc = millisUtc;
        this.timeZoneKey = TimeZoneKey.getTimeZoneKey(timeZone.getID());
    }

    public long getMillisUtc() {
        return this.millisUtc;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public int hashCode() {
        return Objects.hash(this.millisUtc, this.timeZoneKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTimeWithTimeZone other = (SqlTimeWithTimeZone)obj;
        return Objects.equals(this.millisUtc, other.millisUtc) && Objects.equals(this.timeZoneKey, other.timeZoneKey);
    }

    @JsonValue
    public String toString() {
        return Instant.ofEpochMilli(this.millisUtc).atZone(ZoneId.of(this.timeZoneKey.getId())).format(formatter);
    }
}

