/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.Type;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Object readNativeValue(Type type, Block block, int position) {
        Class<?> javaType = type.getJavaType();
        if (block.isNull(position)) {
            return null;
        }
        if (javaType == Long.TYPE) {
            return type.getLong(block, position);
        }
        if (javaType == Double.TYPE) {
            return type.getDouble(block, position);
        }
        if (javaType == Boolean.TYPE) {
            return type.getBoolean(block, position);
        }
        if (javaType == Slice.class) {
            return type.getSlice(block, position);
        }
        return type.getObject(block, position);
    }

    public static void writeNativeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, (Boolean)value);
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (type.getJavaType() == Slice.class) {
            Slice slice = value instanceof byte[] ? Slices.wrappedBuffer((byte[])value) : (value instanceof String ? Slices.utf8Slice((String)value) : (Slice)value);
            type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            type.writeObject(blockBuilder, value);
        }
    }
}

