/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.codedesc;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.Miner;
import org.n3r.diamond.client.Minerable;
import org.n3r.eql.cache.EqlCacheKey;
import org.n3r.eql.codedesc.CodeDesc;
import org.n3r.eql.codedesc.DefaultCodeDescMapper;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.impl.EqlUniqueSqlId;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.param.EqlParamsBinder;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.util.Closes;
import org.n3r.eql.util.EqlUtils;

public class CodeDescCache {
    public static final String EQL_CACHE = "EQL.CACHE.DESC";
    static Cache<EqlUniqueSqlId, Optional<String>> cachEQLIdVersion = CacheBuilder.newBuilder().build();
    static Cache<EqlUniqueSqlId, Cache<EqlCacheKey, Optional<DefaultCodeDescMapper>>> cacheDict = CacheBuilder.newBuilder().build();

    public static DefaultCodeDescMapper getCachedMapper(String sqlClassPath, CodeDesc codeDesc, EqlRun currEqlRun, EqlConfigDecorator eqlConfig, EqlBlock eqlBlock, String tagSqlId) {
        EqlUniqueSqlId uniqueSQLId = new EqlUniqueSqlId(sqlClassPath, codeDesc.getDescLabel());
        Optional cachedSqlIdVersion = (Optional)cachEQLIdVersion.getIfPresent((Object)uniqueSQLId);
        String sqlIdVersion = CodeDescCache.getSqlIdCacheVersion(uniqueSQLId);
        Cache<EqlCacheKey, Optional<DefaultCodeDescMapper>> subCache = CodeDescCache.getOrCreateSubCache(uniqueSQLId);
        EqlCacheKey eqlCacheKey = new EqlCacheKey(uniqueSQLId, codeDesc.getParams(), null, null);
        if (cachedSqlIdVersion != null && !StringUtils.equals((CharSequence)sqlIdVersion, (CharSequence)((CharSequence)cachedSqlIdVersion.orNull()))) {
            subCache.invalidate((Object)eqlCacheKey);
            cachEQLIdVersion.put((Object)uniqueSQLId, (Object)Optional.fromNullable((Object)sqlIdVersion));
        }
        Optional<DefaultCodeDescMapper> mapperOptional = CodeDescCache.getOrCreateMapper(currEqlRun, eqlConfig, codeDesc, eqlBlock, subCache, eqlCacheKey, tagSqlId);
        return (DefaultCodeDescMapper)mapperOptional.orNull();
    }

    private static String getSqlIdCacheVersion(EqlUniqueSqlId uniquEQLId) {
        String dataId = uniquEQLId.getSqlClassPath().replaceAll("/", ".");
        Minerable minerable = new Miner().getMiner(EQL_CACHE, dataId);
        String key = uniquEQLId.getSqlId() + ".cacheVersion";
        return minerable.getString(key);
    }

    private static Optional<DefaultCodeDescMapper> getOrCreateMapper(final EqlRun currEqlRun, final EqlConfigDecorator eqlConfig, final CodeDesc codeDesc, final EqlBlock eqlBlock, Cache<EqlCacheKey, Optional<DefaultCodeDescMapper>> subCache, final EqlCacheKey eqlCacheKey, final String tagSqlId) {
        return (Optional)subCache.get((Object)eqlCacheKey, (Callable)new Callable<Optional<DefaultCodeDescMapper>>(){

            @Override
            public Optional<DefaultCodeDescMapper> call() throws Exception {
                DefaultCodeDescMapper mapper = CodeDescCache.createCodeDescMapper(eqlBlock, currEqlRun, eqlConfig, codeDesc, eqlCacheKey.getUniqueSQLId().getSqlClassPath(), tagSqlId);
                return Optional.fromNullable((Object)mapper);
            }
        });
    }

    private static Cache<EqlCacheKey, Optional<DefaultCodeDescMapper>> getOrCreateSubCache(final EqlUniqueSqlId uniqueSQLId) {
        return (Cache)cacheDict.get((Object)uniqueSQLId, (Callable)new Callable<Cache<EqlCacheKey, Optional<DefaultCodeDescMapper>>>(){

            @Override
            public Cache<EqlCacheKey, Optional<DefaultCodeDescMapper>> call() throws Exception {
                String sqlIdVersion = CodeDescCache.getSqlIdCacheVersion(uniqueSQLId);
                cachEQLIdVersion.put((Object)uniqueSQLId, (Object)Optional.fromNullable((Object)sqlIdVersion));
                return CacheBuilder.newBuilder().build();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DefaultCodeDescMapper createCodeDescMapper(EqlBlock eqlBlock, EqlRun currEqlRun, EqlConfigDecorator eqlConfig, CodeDesc codeDesc, String sqlClassPath, String tagSqlId) {
        DefaultCodeDescMapper defaultCodeDescMapper;
        Map<String, Object> executionContext = EqlUtils.newExecContext(codeDesc.getParams(), null);
        List<EqlRun> eqlRuns = eqlBlock.createEqlRunsByEqls(tagSqlId, eqlConfig, executionContext, codeDesc.getParams(), null);
        if (eqlRuns.size() != 1) {
            throw new EqlExecuteException("only one select sql supported ");
        }
        EqlRun eqlRun = eqlRuns.get(0);
        if (!eqlRun.isLastSelectSql()) {
            throw new EqlExecuteException("only one select sql supported ");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            new EqlParamsBinder().prepareBindParams(eqlBlock.isIterateOption(), eqlRun);
            eqlRun.setConnection(currEqlRun.getConnection());
            ps = EqlUtils.prepareSQL(sqlClassPath, eqlConfig, eqlRun, codeDesc.getDescLabel(), tagSqlId);
            eqlRun.bindParams(ps, sqlClassPath);
            rs = ps.executeQuery();
            rs.setFetchSize(100);
            int columnCount = rs.getMetaData().getColumnCount();
            if (columnCount < 2) {
                throw new EqlExecuteException("should at least two columns used as code and desc");
            }
            DefaultCodeDescMapper mapper = new DefaultCodeDescMapper();
            while (rs.next()) {
                mapper.addMapping(rs.getString(1), rs.getString(2));
            }
            defaultCodeDescMapper = mapper;
        }
        catch (Throwable throwable) {
            try {
                Closes.closeQuietly(rs, ps);
                throw throwable;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        Closes.closeQuietly(rs, ps);
        return defaultCodeDescMapper;
    }
}

