/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.proxy;

import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import org.n3r.eql.dbfieldcryptor.SensitiveCryptor;
import org.n3r.eql.dbfieldcryptor.parser.SensitiveFieldsParser;
import org.n3r.eql.util.O;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CallableStmtHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(CallableStmtHandler.class);
    private final CallableStatement stmt;
    private final SensitiveFieldsParser parser;
    private final SensitiveCryptor cryptor;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (O.in(method.getName(), "setString", "setObject") && this.parser.inBindIndices((Integer)args[0])) {
            try {
                if (args[1] != null) {
                    args[1] = this.cryptor.encrypt(args[1].toString());
                }
            }
            catch (Exception e) {
                log.warn("Encrypt parameter #{}# error", args[1]);
            }
            return method.invoke((Object)this.stmt, args);
        }
        if (O.in(method.getName(), "getString", "getObject") && this.parser.inBindIndices((Integer)args[0])) {
            try {
                Object result = method.invoke((Object)this.stmt, args);
                return result != null ? this.cryptor.decrypt("" + result) : result;
            }
            catch (Exception e) {
                log.warn("Decrypt parameter #{}# error", args[1]);
            }
        }
        return method.invoke((Object)this.stmt, args);
    }

    public CallableStatement createCallableStatement() {
        return (CallableStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CallableStatement.class}, (InvocationHandler)this);
    }

    @ConstructorProperties(value={"stmt", "parser", "cryptor"})
    public CallableStmtHandler(CallableStatement stmt, SensitiveFieldsParser parser, SensitiveCryptor cryptor) {
        this.stmt = stmt;
        this.parser = parser;
        this.cryptor = cryptor;
    }
}

