/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.proxy;

import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.n3r.eql.dbfieldcryptor.SensitiveCryptor;
import org.n3r.eql.dbfieldcryptor.parser.SensitiveFieldsParser;
import org.n3r.eql.dbfieldcryptor.proxy.ResultSetHandler;
import org.n3r.eql.util.O;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreparedStmtHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(PreparedStmtHandler.class);
    private final PreparedStatement pstmt;
    private final SensitiveFieldsParser parser;
    private final SensitiveCryptor cryptor;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (O.in(method.getName(), "setString", "setObject") && this.parser.inBindIndices((Integer)args[0])) {
            try {
                if (args[1] != null) {
                    args[1] = this.cryptor.encrypt(args[1].toString());
                }
            }
            catch (Exception e) {
                log.warn("Encrypt parameter #{}# error", args[1], (Object)e);
            }
        }
        Object result = method.invoke((Object)this.pstmt, args);
        if (O.in(method.getName(), "executeQuery", "getResultSet") && this.parser.getSecureResultIndices().size() > 0) {
            result = new ResultSetHandler((ResultSet)result, this.parser, this.cryptor).createResultSetProxy();
        }
        return result;
    }

    public PreparedStatement createPreparedStatementProxy() {
        return (PreparedStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)this);
    }

    @ConstructorProperties(value={"pstmt", "parser", "cryptor"})
    public PreparedStmtHandler(PreparedStatement pstmt, SensitiveFieldsParser parser, SensitiveCryptor cryptor) {
        this.pstmt = pstmt;
        this.parser = parser;
        this.cryptor = cryptor;
    }
}

