/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.proxy;

import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import org.n3r.eql.dbfieldcryptor.SensitiveCryptor;
import org.n3r.eql.dbfieldcryptor.parser.SensitiveFieldsParser;
import org.n3r.eql.util.O;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultSetHandler.class);
    private ResultSet resultSet;
    private SensitiveFieldsParser parser;
    private SensitiveCryptor cryptor;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke((Object)this.resultSet, args);
        if (result == null) {
            return null;
        }
        if (O.in(method.getName(), "getString", "getObject") && this.parser.inResultIndicesOrLabel(args[0])) {
            try {
                String data = result.toString();
                if (data.length() > 1) {
                    result = this.cryptor.decrypt(data);
                }
            }
            catch (Exception e) {
                log.warn("Decrypt result #{}# error", result);
            }
        }
        return result;
    }

    public ResultSet createResultSetProxy() {
        return (ResultSet)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)this);
    }

    @ConstructorProperties(value={"resultSet", "parser", "cryptor"})
    public ResultSetHandler(ResultSet resultSet, SensitiveFieldsParser parser, SensitiveCryptor cryptor) {
        this.resultSet = resultSet;
        this.parser = parser;
        this.cryptor = cryptor;
    }
}

