/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import java.util.Map;
import org.n3r.eql.base.DynamicLanguageDriver;
import org.n3r.eql.base.EqlResourceLoader;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.config.EqlTranFactoryCacheLifeCycle;
import org.n3r.eql.impl.DefaultDynamicLanguageDriver;
import org.n3r.eql.impl.FileEqlResourceLoader;
import org.n3r.eql.impl.OgnlEvaluator;
import org.n3r.eql.joor.Reflect;
import org.n3r.eql.util.S;

public class DefaultEqlConfigDecorator
implements EqlConfigDecorator {
    private final EqlConfig eqlConfig;
    private EqlResourceLoader eqlResourceLoader;
    private ExpressionEvaluator expressionEvaluator;
    private EqlTranFactoryCacheLifeCycle lifeCycle;

    @Override
    public EqlResourceLoader getSqlResourceLoader() {
        return this.eqlResourceLoader;
    }

    public DefaultEqlConfigDecorator(EqlConfig eqlConfig) {
        this.eqlConfig = eqlConfig;
        if (eqlConfig instanceof EqlTranFactoryCacheLifeCycle) {
            this.lifeCycle = (EqlTranFactoryCacheLifeCycle)((Object)eqlConfig);
        }
        this.parseResourceLoader(eqlConfig);
        this.parseExpressionEvaluator(eqlConfig);
    }

    private boolean parseLazyLoad(EqlConfig eqlConfig) {
        String parseLazyStr = eqlConfig.getStr("sql.parse.lazy");
        return S.isBlank(parseLazyStr) || S.parseBool(parseLazyStr);
    }

    private void parseExpressionEvaluator(EqlConfig eqlConfig) {
        String evaluator = eqlConfig.getStr("expression.evaluator");
        this.expressionEvaluator = S.isBlank(evaluator) ? new OgnlEvaluator() : (ExpressionEvaluator)Reflect.on(evaluator).create().get();
    }

    private void parseResourceLoader(EqlConfig eqlConfig) {
        String loader = eqlConfig.getStr("sql.resource.loader");
        this.eqlResourceLoader = S.isBlank(loader) ? new FileEqlResourceLoader() : (EqlResourceLoader)Reflect.on(loader).create().get();
        this.eqlResourceLoader.setDynamicLanguageDriver(this.parseDynamicLanguageDriver(eqlConfig));
        this.eqlResourceLoader.setEqlLazyLoad(this.parseLazyLoad(eqlConfig));
    }

    private DynamicLanguageDriver parseDynamicLanguageDriver(EqlConfig eqlConfig) {
        String driver = eqlConfig.getStr("dynamic.language.driver");
        return S.isBlank(driver) ? new DefaultDynamicLanguageDriver() : (DynamicLanguageDriver)Reflect.on(driver).create().get();
    }

    @Override
    public String getStr(String key) {
        return this.eqlConfig.getStr(key);
    }

    @Override
    public Map<String, String> params() {
        return this.eqlConfig.params();
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEqlConfigDecorator that = (DefaultEqlConfigDecorator)o;
        return this.eqlConfig.equals(that.eqlConfig);
    }

    public int hashCode() {
        return this.eqlConfig.hashCode();
    }

    @Override
    public void onLoad() {
        if (this.lifeCycle != null) {
            this.lifeCycle.onLoad();
        }
    }

    @Override
    public void onRemoval() {
        if (this.lifeCycle != null) {
            this.lifeCycle.onRemoval();
        }
    }
}

