/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import org.n3r.eql.impl.EqlRsRetriever;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.param.EqlParamPlaceholder;

public class EqlProc {
    private final EqlRun eqlRun;
    private final EqlRsRetriever rsRetriever;

    public Object dealProcedure(PreparedStatement ps) {
        return this.execAndRetrieveProcedureRet(this.eqlRun, (CallableStatement)ps);
    }

    private Object execAndRetrieveProcedureRet(EqlRun subSql, CallableStatement cs) {
        cs.execute();
        if (subSql.getOutCount() == 0) {
            return null;
        }
        if (subSql.getOutCount() == 1) {
            int ii = subSql.getPlaceHolders().length;
            for (int i = 0; i < ii; ++i) {
                if (subSql.getPlaceHolders()[i].getInOut() == EqlParamPlaceholder.InOut.IN) continue;
                return cs.getObject(i + 1);
            }
        }
        switch (subSql.getPlaceHolderOutType()) {
            case AUTO_SEQ: {
                return this.retrieveAutoSeqOuts(subSql, cs);
            }
            case VAR_NAME: {
                return this.rsRetriever.getCallableReturnMapper().mapResult(subSql, cs);
            }
        }
        return null;
    }

    private Object retrieveAutoSeqOuts(EqlRun subSql, CallableStatement cs) {
        ArrayList objects = Lists.newArrayList();
        int ii = subSql.getPlaceHolders().length;
        for (int i = 0; i < ii; ++i) {
            if (subSql.getPlaceHolders()[i].getInOut() == EqlParamPlaceholder.InOut.IN) continue;
            objects.add(cs.getObject(i + 1));
        }
        return objects;
    }

    @ConstructorProperties(value={"eqlRun", "rsRetriever"})
    public EqlProc(EqlRun eqlRun, EqlRsRetriever rsRetriever) {
        this.eqlRun = eqlRun;
        this.rsRetriever = rsRetriever;
    }
}

