/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.n3r.eql.base.EqlResourceLoader;
import org.n3r.eql.impl.EqlUniqueSqlId;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.parser.EqlParser;

public class EqlResourceLoaderHelper {
    public static LoadingCache<EqlUniqueSqlId, Optional<EqlBlock>> buildSqlCache(final Cache<String, Optional<Map<String, EqlBlock>>> fileCache) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<EqlUniqueSqlId, Optional<EqlBlock>>(){

            public Optional<EqlBlock> load(EqlUniqueSqlId eqlUniqueSqlId) throws Exception {
                return EqlResourceLoaderHelper.loadBlocks((Cache<String, Optional<Map<String, EqlBlock>>>)fileCache, eqlUniqueSqlId);
            }
        });
    }

    private static Optional<EqlBlock> loadBlocks(Cache<String, Optional<Map<String, EqlBlock>>> fileCache, EqlUniqueSqlId eqlUniqueSqlId) {
        Optional blocks = (Optional)fileCache.getIfPresent((Object)eqlUniqueSqlId.getSqlClassPath());
        if (!blocks.isPresent()) {
            return Optional.absent();
        }
        EqlBlock eqlBlock = (EqlBlock)((Map)blocks.get()).get(eqlUniqueSqlId.getSqlId());
        if (eqlBlock == null) {
            return Optional.absent();
        }
        eqlBlock.tryParseSqls();
        return Optional.of((Object)eqlBlock);
    }

    public static void updateBlockCache(String sqlContent, EqlResourceLoader eqlResourceLoader, String sqlClassPath, Cache<EqlUniqueSqlId, Optional<EqlBlock>> sqlCache, Cache<String, Optional<Map<String, EqlBlock>>> fileCache) {
        Optional oldBlocks = (Optional)fileCache.getIfPresent((Object)sqlClassPath);
        Set oldSqlIds = ((Map)oldBlocks.or(new HashMap())).keySet();
        EqlParser eqlParser = new EqlParser(eqlResourceLoader, sqlClassPath);
        Map<String, EqlBlock> sqlBlocks = eqlParser.parse(sqlContent);
        for (EqlBlock sqlBlock : sqlBlocks.values()) {
            EqlUniqueSqlId uniqueSqlId = sqlBlock.getUniqueSqlId();
            sqlCache.put((Object)uniqueSqlId, (Object)Optional.of((Object)sqlBlock));
            oldSqlIds.remove(uniqueSqlId.getSqlId());
        }
        for (String uniqueId : oldSqlIds) {
            sqlCache.invalidate((Object)new EqlUniqueSqlId(sqlClassPath, uniqueId));
        }
        fileCache.put((Object)sqlClassPath, (Object)Optional.of(sqlBlocks));
    }

    public static Map<String, EqlBlock> updateFileCache(String sqlContent, EqlResourceLoader eqlResourceLoader, String sqlClassPath, boolean eqlLazyLoad) {
        EqlParser eqlParser = new EqlParser(eqlResourceLoader, sqlClassPath);
        return eqlLazyLoad ? eqlParser.delayParse(sqlContent) : eqlParser.parse(sqlContent);
    }
}

