/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.n3r.eql.base.DynamicLanguageDriver;
import org.n3r.eql.parser.DelaySql;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.parser.ParserUtils;
import org.n3r.eql.parser.Sql;
import org.n3r.eql.util.S;

public class EqlBlockParser {
    private DynamicLanguageDriver dynamicLanguageDriver;
    private final boolean sqlParseDelay;
    private List<Sql> sqls = Lists.newArrayList();

    public EqlBlockParser(DynamicLanguageDriver dynamicLanguageDriver, boolean sqlParseDelay) {
        this.dynamicLanguageDriver = dynamicLanguageDriver;
        this.sqlParseDelay = sqlParseDelay;
    }

    public void parse(EqlBlock block, List<String> sqlLines) {
        ArrayList oneSqlLines = Lists.newArrayList();
        for (String sqlLine : sqlLines) {
            if (sqlLine.endsWith(block.getSplit())) {
                oneSqlLines.add(sqlLine.substring(0, sqlLine.length() - 1));
                this.addSql(block, oneSqlLines);
                continue;
            }
            oneSqlLines.add(sqlLine);
        }
        this.addSql(block, oneSqlLines);
        block.setSqls(this.sqls);
        block.setSqlLines(sqlLines);
    }

    private void addSql(EqlBlock block, List<String> oneSqlLines) {
        Sql sql;
        if (oneSqlLines.size() == 0) {
            return;
        }
        if (this.isAllComments(oneSqlLines)) {
            return;
        }
        Sql sql2 = sql = this.sqlParseDelay ? new DelaySql(this.dynamicLanguageDriver, block, new ArrayList<String>(oneSqlLines)) : this.dynamicLanguageDriver.parse(block, oneSqlLines);
        if (sql != null) {
            this.sqls.add(sql);
        }
        oneSqlLines.clear();
    }

    private boolean isAllComments(List<String> oneSqlLines) {
        ArrayList linesWoLineComments = Lists.newArrayList();
        for (String line : oneSqlLines) {
            if (line.startsWith("--")) continue;
            linesWoLineComments.add(line);
        }
        if (linesWoLineComments.size() == 0) {
            return true;
        }
        String join = Joiner.on((char)'\n').join((Iterable)linesWoLineComments);
        Matcher matcher = ParserUtils.inlineComment.matcher(join);
        String pureSql = matcher.replaceAll("");
        return S.isBlank(pureSql);
    }
}

