/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import java.util.List;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.IfCondition;

public final class SwitchPart
implements EqlPart {
    private final String condition;
    private final List<IfCondition> cases;

    @Override
    public String evalSql(EqlRun eqlRun) {
        ExpressionEvaluator evaluator = eqlRun.getEqlConfig().getExpressionEvaluator();
        Object target = evaluator.eval(this.condition, eqlRun);
        if (target == null) {
            return "";
        }
        String strTarget = target.toString();
        for (IfCondition ifCondition : this.cases) {
            if (!"".equals(ifCondition.getExpr()) && !Objects.equal((Object)strTarget, (Object)ifCondition.getExpr())) continue;
            return ifCondition.getValue().evalSql(eqlRun);
        }
        return "";
    }

    @ConstructorProperties(value={"condition", "cases"})
    public SwitchPart(String condition, List<IfCondition> cases) {
        this.condition = condition;
        this.cases = cases;
    }

    public String getCondition() {
        return this.condition;
    }

    public List<IfCondition> getCases() {
        return this.cases;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwitchPart)) {
            return false;
        }
        SwitchPart other = (SwitchPart)o;
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        List<IfCondition> this$cases = this.getCases();
        List<IfCondition> other$cases = other.getCases();
        return !(this$cases == null ? other$cases != null : !((Object)this$cases).equals(other$cases));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        List<IfCondition> $cases = this.getCases();
        result = result * 59 + ($cases == null ? 43 : ((Object)$cases).hashCode());
        return result;
    }

    public String toString() {
        return "SwitchPart(condition=" + this.getCondition() + ", cases=" + this.getCases() + ")";
    }
}

