/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.spec;

import java.util.ArrayList;
import java.util.List;
import org.n3r.eql.spec.Spec;

public class SpecParser {
    public static Spec parseSpecLeniently(String spec) {
        Spec[] specs = SpecParser.parseSpecs(spec);
        return specs.length == 0 ? null : specs[0];
    }

    public static Spec parseSpec(String spec) {
        Spec[] specs = SpecParser.parseSpecs(spec);
        if (specs.length > 1) {
            throw new RuntimeException("too many spec defined");
        }
        return specs.length == 0 ? null : specs[0];
    }

    public static Spec[] parseSpecs(String specs) {
        int i;
        char[] chars = specs.toCharArray();
        SpecState specState = SpecState.SpecClose;
        StringBuilder name = new StringBuilder();
        StringBuilder param = new StringBuilder();
        ParamQuoteState paramQuoteState = ParamQuoteState.None;
        ArrayList<Spec> specsDefs = new ArrayList<Spec>();
        Spec spec = null;
        char ch = ' ';
        int ii = chars.length;
        block22: for (i = 0; i < ii; ++i) {
            ch = chars[i];
            switch (specState) {
                case SpecClose: {
                    if (ch == '@') {
                        specState = SpecState.SpecOpen;
                        paramQuoteState = ParamQuoteState.None;
                        continue block22;
                    }
                    if (Character.isWhitespace(ch)) continue block22;
                    SpecParser.error(specs, i, ch);
                    continue block22;
                }
                case SpecOpen: {
                    if (Character.isJavaIdentifierStart(ch)) {
                        specState = SpecState.SpecName;
                        name.append(ch);
                        continue block22;
                    }
                    SpecParser.error(specs, i, ch);
                    continue block22;
                }
                case SpecName: {
                    if (Character.isJavaIdentifierPart(ch) || ch == '.' || ch == '$') {
                        name.append(ch);
                        continue block22;
                    }
                    if (Character.isWhitespace(ch) || ch == '@' || ch == '(') {
                        while (i < ii && Character.isWhitespace(chars[i])) {
                            ++i;
                        }
                        if (i < ii) {
                            ch = chars[i];
                        }
                        specState = ch == '(' ? SpecState.ParamOpen : SpecState.SpecClose;
                        spec = SpecParser.addSpec(name, specsDefs);
                        if (specState != SpecState.SpecClose) continue block22;
                        --i;
                        continue block22;
                    }
                    SpecParser.error(specs, i, ch);
                    continue block22;
                }
                case ParamOpen: {
                    switch (ch) {
                        case ')': {
                            SpecParser.addSpecParam(param, paramQuoteState, spec);
                            specState = SpecState.SpecClose;
                            continue block22;
                        }
                        case '\"': {
                            paramQuoteState = ParamQuoteState.Left;
                            specState = SpecState.ParamValue;
                            SpecParser.clear(param);
                            continue block22;
                        }
                        case '\\': {
                            ch = SpecParser.convertpecialChar(chars[++i]);
                        }
                    }
                    if (Character.isWhitespace(ch)) continue block22;
                    param.append(ch);
                    specState = SpecState.ParamValue;
                    continue block22;
                }
                case ParamValue: {
                    switch (ch) {
                        case ')': {
                            if (paramQuoteState == ParamQuoteState.Left) {
                                param.append(ch);
                                continue block22;
                            }
                            SpecParser.addSpecParam(param, paramQuoteState, spec);
                            specState = SpecState.SpecClose;
                            continue block22;
                        }
                        case ',': {
                            if (paramQuoteState == ParamQuoteState.Left) {
                                param.append(ch);
                                continue block22;
                            }
                            SpecParser.addSpecParam(param, paramQuoteState, spec);
                            paramQuoteState = ParamQuoteState.None;
                            specState = SpecState.ParamOpen;
                            continue block22;
                        }
                        case '\"': {
                            if (paramQuoteState == ParamQuoteState.Left) {
                                paramQuoteState = ParamQuoteState.Right;
                                continue block22;
                            }
                            SpecParser.error(specs, i, ch);
                            continue block22;
                        }
                        case '\\': {
                            ch = SpecParser.convertpecialChar(chars[++i]);
                        }
                    }
                    if (paramQuoteState == ParamQuoteState.Right) {
                        if (Character.isWhitespace(ch)) continue block22;
                        SpecParser.error(specs, i, ch);
                        continue block22;
                    }
                    param.append(ch);
                    continue block22;
                }
                default: {
                    SpecParser.error(specs, i, ch);
                }
            }
        }
        switch (specState) {
            case SpecName: {
                SpecParser.addSpec(name, specsDefs);
                break;
            }
            case SpecOpen: 
            case ParamOpen: 
            case ParamValue: {
                SpecParser.error(specs, i, ch);
            }
        }
        return specsDefs.toArray(new Spec[0]);
    }

    private static Spec addSpec(StringBuilder name, List<Spec> specsDefs) {
        Spec spec = new Spec();
        spec.setName(name.toString());
        SpecParser.clear(name);
        specsDefs.add(spec);
        return spec;
    }

    private static void addSpecParam(StringBuilder param, ParamQuoteState paramInQuote, Spec spec) {
        spec.addParam(paramInQuote == ParamQuoteState.Right ? param.toString() : SpecParser.trimSubstring(param));
        SpecParser.clear(param);
    }

    private static StringBuilder clear(StringBuilder param) {
        return param.delete(0, param.length());
    }

    public static String trimSubstring(StringBuilder sb) {
        int first;
        int last = sb.length();
        int ii = sb.length();
        for (first = 0; first < ii && Character.isWhitespace(sb.charAt(first)); ++first) {
        }
        while (last > first && Character.isWhitespace(sb.charAt(last - 1))) {
            --last;
        }
        return sb.substring(first, last);
    }

    private static Spec[] error(String specs, int i, char ch) {
        throw new RuntimeException(specs + " is invalid at pos " + i + " with char " + ch);
    }

    private static char convertpecialChar(char aChar) {
        switch (aChar) {
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
        }
        return aChar;
    }

    private static enum ParamQuoteState {
        None,
        Left,
        Right;

    }

    private static enum SpecState {
        SpecOpen,
        SpecName,
        ParamOpen,
        ParamValue,
        SpecClose;

    }
}

