/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.trans;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.trans.AbstractEqlConnection;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.O;
import org.n3r.eql.util.PropertyValueFilter;

public class EqlHikariConnection
extends AbstractEqlConnection {
    HikariDataSource dataSource;

    @Override
    public void initialize(EqlConfig eqlConfig) {
        Map<String, String> params = eqlConfig.params();
        EqlUtils.compatibleWithUserToUsername(params);
        HikariConfig config = new HikariConfig();
        O.populate(config, params, new PropertyValueFilter[0]);
        this.dataSource = new HikariDataSource(config);
    }

    @Override
    public Connection getConnection(String dbName) {
        return this.dataSource.getConnection();
    }

    @Override
    public void destroy() {
        this.dataSource.close();
    }

    @Override
    public String getDriverName() {
        return EqlUtils.getDriverNameFromConnection((DataSource)this.dataSource);
    }

    @Override
    public String getJdbcUrl() {
        return this.dataSource.getJdbcUrl();
    }
}

