/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import java.util.List;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.util.BlackcatUtils;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.S;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Logs {
    public static void logResult(EqlConfig eqlConfig, String sqlClassPath, Object execRet, String sqlId, String tagSqlId) {
        int logMaxRows;
        Logger logger = Logs.createLogger(eqlConfig, sqlClassPath, sqlId, tagSqlId, "result");
        if (!(execRet instanceof List)) {
            logger.debug("" + execRet);
            BlackcatUtils.log("SQL.RESULT", "" + execRet, new Object[0]);
            return;
        }
        List list = (List)execRet;
        int size = list.size();
        if (size > (logMaxRows = EqlUtils.getConfigInt(eqlConfig, "result.log.max", 50))) {
            List logRows = list.subList(0, logMaxRows);
            logger.debug("first {}/{} rows: {}", new Object[]{logMaxRows, size, logRows});
            BlackcatUtils.log("SQL.RESULT", "first {}/{} rows: {}", logMaxRows, size, logRows);
        } else {
            logger.debug("total {} rows of: {}", (Object)size, (Object)list);
            BlackcatUtils.log("SQL.RESULT", "total {} rows of: {}", size, list);
        }
    }

    public static Logger createLogger(EqlConfig eqlConfig, String sqlClassPath, String sqlId, String tagSqlId, String tag) {
        String loggerPrefix = eqlConfig.getStr("logger.prefix");
        if (S.isBlank(loggerPrefix) || loggerPrefix.equals("auto")) {
            loggerPrefix = "eql";
        }
        if (loggerPrefix.endsWith(".")) {
            loggerPrefix = loggerPrefix.substring(0, loggerPrefix.length() - 1);
        }
        String sqlClassPathNullable = sqlClassPath == null ? "null" : sqlClassPath;
        String thisSqlId = S.isNotBlank(tagSqlId) ? tagSqlId : sqlId;
        String loggerName = loggerPrefix + '.' + sqlClassPathNullable.replace('/', '.') + '.' + thisSqlId + '.' + tag;
        String stripDollarLoggerName = loggerName.replace('$', '_');
        return LoggerFactory.getLogger((String)stripDollarLoggerName);
    }
}

