/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.option.Option;
import com.github.dandelion.core.util.OptionUtils;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.option.ColumnConfiguration;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import com.github.dandelion.datatables.jsp.extension.feature.FilteringFeature;
import com.github.dandelion.datatables.jsp.tag.TableTag;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnTag
extends BodyTagSupport
implements DynamicAttributes {
    private static final long serialVersionUID = -7564020161222133531L;
    private static Logger logger = LoggerFactory.getLogger(ColumnTag.class);
    private Map<Option<?>, Object> stagingOptions = new HashMap();
    private Map<Option<?>, Extension> stagingExtensions = new HashMap();
    private String title;
    private String titleKey;
    private String property;
    private String defaultValue;
    private String cssCellStyle;
    private String cssCellClass;
    private String format;
    private String display;
    private boolean escapeXml = true;
    private HttpServletRequest request;
    private Map<String, String> dynamicAttributes;
    private HtmlColumn headerColumn;

    public int doStartTag() throws JspException {
        this.request = (HttpServletRequest)this.pageContext.getRequest();
        TableTag parent = (TableTag)ColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent != null) {
            if (parent.isFirstIteration()) {
                this.headerColumn = new HtmlColumn(Boolean.valueOf(true), null, this.dynamicAttributes, this.display);
                this.request.setAttribute(ColumnConfiguration.class.getCanonicalName(), (Object)this.headerColumn.getColumnConfiguration());
            }
            if (StringUtils.isNotBlank((String)this.property)) {
                return 0;
            }
            return 2;
        }
        throw new JspException("The tag 'column' must be inside the 'table' tag.");
    }

    public int doEndTag() throws JspException {
        TableTag parent = (TableTag)ColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent.isFirstIteration()) {
            String columnTitle = StringUtils.escape((boolean)this.escapeXml, (String)this.title);
            if (columnTitle == null && this.titleKey != null) {
                if (parent.getTable().getTableConfiguration().getMessageResolver() != null) {
                    columnTitle = parent.getTable().getTableConfiguration().getMessageResolver().getResource(this.titleKey, StringUtils.escape((boolean)this.escapeXml, (String)this.property), new Object[]{this.pageContext});
                } else {
                    columnTitle = "???" + this.titleKey + "???";
                    logger.warn("You cannot use the 'titleKey' attribute if no message resolver is configured. Please take a look at the {} property in the configuration reference.", (Object)"i18n.message.resolver");
                }
            }
            if ("DOM".equals(parent.getDataSourceType())) {
                this.addDomHeaderColumn(columnTitle);
            } else if ("AJAX".equals(parent.getDataSourceType())) {
                this.addAjaxHeaderColumn(true, columnTitle);
                return 6;
            }
        }
        if (parent.getCurrentObject() != null) {
            String columnContent = null;
            if (StringUtils.isNotBlank((String)this.property)) {
                columnContent = this.getColumnContent();
            } else if (this.getBodyContent() != null) {
                columnContent = this.getBodyContent().getString().trim().replaceAll("[\n\r]", "");
            }
            this.addDomBodyColumn(columnContent);
        }
        return 6;
    }

    private void addDomHeaderColumn(String content) throws JspException {
        TableTag parent = (TableTag)ColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (content != null) {
            this.headerColumn.setContent(new StringBuilder(content));
        }
        this.headerColumn.getColumnConfiguration().getOptions().putAll(this.stagingOptions);
        this.headerColumn.getColumnConfiguration().getStagingExtension().putAll(this.stagingExtensions);
        OptionUtils.processOptions((Map)this.headerColumn.getColumnConfiguration().getOptions(), (HttpServletRequest)this.request);
        parent.getTable().getLastHeaderRow().addColumn(this.headerColumn);
    }

    private void addDomBodyColumn(String content) throws JspException {
        TableTag parent = (TableTag)ColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
        HtmlColumn bodyColumn = new HtmlColumn(Boolean.valueOf(false), content, this.dynamicAttributes, this.display);
        if (StringUtils.isNotBlank((String)this.cssCellClass)) {
            bodyColumn.addCssCellClass(this.cssCellClass);
        }
        if (StringUtils.isNotBlank((String)this.cssCellStyle)) {
            bodyColumn.addCssCellStyle(this.cssCellStyle);
        }
        parent.getTable().getLastBodyRow().addColumn(bodyColumn);
    }

    private void addAjaxHeaderColumn(Boolean isHeader, String content) throws JspException {
        TableTag parent = (TableTag)ColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (content != null) {
            this.headerColumn.setContent(new StringBuilder(content));
        }
        if (StringUtils.isNotBlank((String)this.defaultValue)) {
            this.headerColumn.getColumnConfiguration().getOptions().put(DatatableOptions.DEFAULTVALUE, this.defaultValue);
        } else {
            this.headerColumn.getColumnConfiguration().getOptions().put(DatatableOptions.DEFAULTVALUE, "");
        }
        this.headerColumn.getColumnConfiguration().getOptions().putAll(this.stagingOptions);
        this.headerColumn.getColumnConfiguration().getStagingExtension().putAll(this.stagingExtensions);
        OptionUtils.processOptions((Map)this.headerColumn.getColumnConfiguration().getOptions(), (HttpServletRequest)this.request);
        parent.getTable().getLastHeaderRow().addColumn(this.headerColumn);
    }

    private String getColumnContent() throws JspException {
        block11: {
            TableTag parent = (TableTag)ColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
            if (StringUtils.isNotBlank((String)this.property) && parent.getCurrentObject() != null) {
                Object propertyValue = null;
                try {
                    propertyValue = PropertyUtils.getNestedProperty((Object)parent.getCurrentObject(), (String)this.property.trim());
                    if (StringUtils.isNotBlank((String)this.format) && propertyValue != null) {
                        MessageFormat messageFormat = new MessageFormat(this.format);
                        return messageFormat.format(new Object[]{propertyValue});
                    }
                    if (StringUtils.isBlank((String)this.format) && propertyValue != null) {
                        return StringUtils.escape((String)propertyValue.toString());
                    }
                    if (StringUtils.isNotBlank((String)this.defaultValue)) {
                        return this.defaultValue.trim();
                    }
                    break block11;
                }
                catch (NestedNullException e) {
                    if (StringUtils.isNotBlank((String)this.defaultValue)) {
                        return this.defaultValue.trim();
                    }
                    break block11;
                }
                catch (IllegalAccessException e) {
                    throw new JspException("Unable to get the value for the given property: \"" + this.property + "\"", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new JspException("Unable to get the value for the given property: \"" + this.property + "\"", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new JspException("Unable to get the value for the given property: \"" + this.property + "\"", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    logger.error("Wrong MessageFormat pattern : {}", (Object)this.format);
                    return propertyValue.toString();
                }
            }
            return "";
        }
        return "";
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.validateDynamicAttribute(localName, value);
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new HashMap<String, String>();
        }
        this.dynamicAttributes.put(localName, (String)value);
    }

    private void validateDynamicAttribute(String localName, Object value) {
        if (localName.equals("class")) {
            throw new IllegalArgumentException("The 'class' attribute is not allowed. Please use the 'cssClass' or the 'cssCellClass' attribute instead.");
        }
        if (localName.equals("style")) {
            throw new IllegalArgumentException("The 'style' attribute is not allowed. Please use the 'cssStyle' or the 'cssCellStyle' attribute instead.");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("The attribute " + localName + " won't be added to the table. Only string values are accepted.");
        }
    }

    public HtmlColumn getHeaderColumn() {
        return this.headerColumn;
    }

    public Map<Option<?>, Object> getStagingConf() {
        return this.stagingOptions;
    }

    public void setTitle(String titleKey) {
        this.title = titleKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }

    public void setName(String name) {
        this.stagingOptions.put(DatatableOptions.NAME, name);
    }

    public void setProperty(String property) {
        this.property = property;
        this.stagingOptions.put(DatatableOptions.PROPERTY, property);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setCssStyle(String cssStyle) {
        this.stagingOptions.put(DatatableOptions.CSSSTYLE, cssStyle);
    }

    public void setCssClass(String cssClass) {
        this.stagingOptions.put(DatatableOptions.CSSCLASS, cssClass);
    }

    public void setSortable(Boolean sortable) {
        this.stagingOptions.put(DatatableOptions.SORTABLE, sortable);
    }

    public void setCssCellStyle(String cssCellStyle) {
        this.cssCellStyle = cssCellStyle;
        this.stagingOptions.put(DatatableOptions.CSSCELLSTYLE, cssCellStyle);
    }

    public void setCssCellClass(String cssCellClass) {
        this.cssCellClass = cssCellClass;
        this.stagingOptions.put(DatatableOptions.CSSCELLCLASS, cssCellClass);
    }

    public void setFilterable(Boolean filterable) {
        this.stagingOptions.put(DatatableOptions.FILTERABLE, filterable);
        this.stagingExtensions.put(DatatableOptions.FILTERABLE, (Extension)new FilteringFeature());
    }

    public void setSearchable(Boolean searchable) {
        this.stagingOptions.put(DatatableOptions.SEARCHABLE, searchable);
    }

    public void setVisible(Boolean visible) {
        this.stagingOptions.put(DatatableOptions.VISIBLE, visible);
    }

    public void setFilterType(String filterType) {
        this.stagingOptions.put(DatatableOptions.FILTERTYPE, filterType);
    }

    public void setFilterValues(String filterValues) {
        this.stagingOptions.put(DatatableOptions.FILTERVALUES, filterValues);
    }

    public void setFilterPlaceholder(String filterPlaceholder) {
        this.stagingOptions.put(DatatableOptions.FILTERPLACEHOLDER, filterPlaceholder);
    }

    public void setSortDirection(String sortDirection) {
        this.stagingOptions.put(DatatableOptions.SORTDIRECTION, sortDirection);
    }

    public void setSortInitDirection(String sortInitDirection) {
        this.stagingOptions.put(DatatableOptions.SORTINITDIRECTION, sortInitDirection);
    }

    public void setSortInitOrder(String sortInitOrder) {
        this.stagingOptions.put(DatatableOptions.SORTINITORDER, sortInitOrder);
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
        this.stagingOptions.put(DatatableOptions.DEFAULTVALUE, defaultValue);
    }

    public void setRenderFunction(String renderFunction) {
        this.stagingOptions.put(DatatableOptions.RENDERFUNCTION, renderFunction);
    }

    public void setSelector(String selector) {
        this.stagingOptions.put(DatatableOptions.SELECTOR, selector);
    }

    public void setSortType(String sortType) {
        this.stagingOptions.put(DatatableOptions.SORTTYPE, sortType);
    }

    public void setId(String id) {
        this.stagingOptions.put(DatatableOptions.ID, id);
    }
}

