/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.asset.generator.js.jquery.JQueryContentPlaceholder;
import com.github.dandelion.core.util.EnumUtils;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.extension.feature.ExtraJs;
import com.github.dandelion.datatables.core.extension.feature.ExtraJsFeature;
import com.github.dandelion.datatables.jsp.tag.TableTag;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

public class ExtraJsTag
extends TagSupport {
    private static final long serialVersionUID = -287813095911386884L;
    private String bundles;
    private String placeholder;

    public int doStartTag() throws JspException {
        TableTag parent = (TableTag)ExtraJsTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent != null) {
            return 0;
        }
        throw new JspException("The tag 'extraJs' must be inside the 'table' tag.");
    }

    public int doEndTag() throws JspException {
        TableTag parent = (TableTag)ExtraJsTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent.isFirstIteration()) {
            JQueryContentPlaceholder placeholder = null;
            if (StringUtils.isNotBlank((String)this.placeholder)) {
                try {
                    placeholder = JQueryContentPlaceholder.valueOf((String)this.placeholder.toUpperCase().trim());
                }
                catch (IllegalArgumentException e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("'");
                    sb.append(this.placeholder);
                    sb.append("' is not a valid insert mode. Possible values are: ");
                    sb.append(EnumUtils.printPossibleValuesOf(JQueryContentPlaceholder.class));
                    throw new JspException(sb.toString());
                }
            } else {
                placeholder = JQueryContentPlaceholder.BEFORE_ALL;
            }
            parent.getTable().getTableConfiguration().addExtraJs(new ExtraJs(new HashSet<String>(Arrays.asList(this.bundles.split(","))), placeholder));
            parent.getTable().getTableConfiguration().registerExtension((Extension)new ExtraJsFeature());
        }
        return 6;
    }

    public void setBundles(String bundles) {
        this.bundles = bundles;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }
}

