/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import smile.data.Attribute;

public class NominalAttribute
extends Attribute {
    private boolean open = true;
    private List<String> values = new ArrayList<String>();
    private HashMap<String, Integer> map = new HashMap();

    public NominalAttribute(String name) {
        this(name, 1.0);
    }

    public NominalAttribute(String name, double weight) {
        this(name, null, weight);
    }

    public NominalAttribute(String name, String description) {
        this(name, description, 1.0);
    }

    public NominalAttribute(String name, String description, double weight) {
        super(Attribute.Type.NOMINAL, name, description, weight);
        this.open = true;
    }

    public NominalAttribute(String name, String[] values) {
        this(name, 1.0, values);
    }

    public NominalAttribute(String name, double weight, String[] values) {
        this(name, null, weight, values);
    }

    public NominalAttribute(String name, String description, String[] values) {
        this(name, description, 1.0, values);
    }

    public NominalAttribute(String name, String description, double weight, String[] values) {
        super(Attribute.Type.NOMINAL, name, description, weight);
        this.open = false;
        for (int i = 0; i < values.length; ++i) {
            this.values.add(values[i]);
            this.map.put(values[i], i);
        }
    }

    public int size() {
        return this.values.size();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public String[] values() {
        return this.values.toArray(new String[this.values.size()]);
    }

    public double valueOf(String s) throws ParseException {
        Integer i = this.map.get(s);
        if (i == null) {
            if (this.open) {
                i = this.values.size();
                this.map.put(s, i);
                this.values.add(s);
            } else {
                throw new IllegalArgumentException("Invalid string value: " + s);
            }
        }
        return i.intValue();
    }

    public String toString(double x) {
        if (Double.isNaN(x)) {
            return null;
        }
        if (Math.floor(x) != x) {
            throw new IllegalArgumentException("The input nominal value is not an integer: " + x);
        }
        if (x < 0.0 || x >= (double)this.values.size()) {
            throw new IllegalArgumentException("Invalid nominal value: " + x);
        }
        return this.values.get((int)x);
    }
}

