/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import smile.data.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAttribute
extends Attribute {
    private boolean open = true;
    private List<String> values = new ArrayList<String>();
    private Map<String, Integer> map = new HashMap<String, Integer>();

    public StringAttribute(String name) {
        super(Attribute.Type.STRING, name);
        this.values.add(null);
    }

    public StringAttribute(String name, double weight) {
        super(Attribute.Type.STRING, name, weight);
        this.values.add(null);
    }

    public StringAttribute(String name, String description, double weight) {
        super(Attribute.Type.STRING, name, description, weight);
        this.values.add(null);
    }

    public List<String> values() {
        return this.values;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public double valueOf(String s) throws ParseException {
        Integer i = this.map.get(s);
        if (i == null) {
            if (this.open) {
                i = this.values.size();
                this.map.put(s, i);
                this.values.add(s);
            } else {
                return 0.0;
            }
        }
        return i.intValue();
    }

    @Override
    public String toString(double x) {
        if (Double.isNaN(x)) {
            return null;
        }
        if (Math.floor(x) != x) {
            throw new IllegalArgumentException("The input string index is not an integer: " + x);
        }
        if (x < 0.0 || x >= (double)this.values.size()) {
            throw new IllegalArgumentException("Invalid string index: " + x);
        }
        return this.values.get((int)x);
    }
}

