/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import java.util.Arrays;
import smile.data.Attribute;
import smile.data.NominalAttribute;
import smile.data.SparseDataset;
import smile.math.Math;

public class LibsvmParser {
    public SparseDataset parse(URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(uri));
    }

    public SparseDataset parse(String name, URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new File(uri));
    }

    public SparseDataset parse(String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(path));
    }

    public SparseDataset parse(String name, String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new File(path));
    }

    public SparseDataset parse(File file) throws FileNotFoundException, IOException, ParseException {
        String name = file.getPath();
        return this.parse(name, new FileInputStream(file));
    }

    public SparseDataset parse(String name, File file) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new FileInputStream(file));
    }

    public SparseDataset parse(String name, InputStream stream) throws IOException, ParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Empty data source.");
        }
        String[] tokens = line.trim().split("\\s+");
        boolean classification = true;
        NominalAttribute response = null;
        try {
            Integer.valueOf(tokens[0]);
            response = new NominalAttribute("class");
        }
        catch (NumberFormatException e) {
            try {
                Double.valueOf(tokens[0]);
                response = new NominalAttribute("response");
                classification = false;
            }
            catch (NumberFormatException ex) {
                System.err.println(ex);
                throw new NumberFormatException("Unrecognized response variable value: " + tokens[0]);
            }
        }
        SparseDataset sparse = new SparseDataset(name, response);
        int i = 0;
        while (line != null) {
            tokens = line.trim().split("\\s+");
            if (classification) {
                int y = Integer.valueOf(tokens[0]);
                sparse.set(i, y);
            } else {
                double y = Double.valueOf(tokens[0]);
                sparse.set(i, y);
            }
            for (int k = 1; k < tokens.length; ++k) {
                String[] pair = tokens[k].split(":");
                if (pair.length != 2) {
                    throw new NumberFormatException("Invalid data: " + tokens[k]);
                }
                int j = Integer.valueOf(pair[0]) - 1;
                double x = Double.valueOf(pair[1]);
                sparse.set(i, j, x);
            }
            line = reader.readLine();
            ++i;
        }
        stream.close();
        if (classification) {
            int n = sparse.size();
            int[] y = sparse.toArray(new int[n]);
            int[] label = Math.unique((int[])y);
            Arrays.sort(label);
            for (int c : label) {
                ((Attribute)response).valueOf(String.valueOf(c));
            }
            for (int i2 = 0; i2 < n; ++i2) {
                sparse.get((int)i2).y = Arrays.binarySearch(label, y[i2]);
            }
        }
        return sparse;
    }
}

