/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.http;

import com.github.loki4j.client.http.HttpConfig;
import com.github.loki4j.client.http.Loki4jHttpClient;
import com.github.loki4j.client.http.LokiResponse;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public final class ApacheHttpClient
implements Loki4jHttpClient {
    private final HttpConfig conf;
    private final CloseableHttpClient client;
    private final Supplier<HttpPost> requestBuilder;
    private byte[] bodyBuffer = new byte[0];

    public ApacheHttpClient(final HttpConfig conf) {
        this.conf = conf;
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(conf.apache().maxConnections);
        cm.setDefaultMaxPerRoute(conf.apache().maxConnections);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return conf.apache().connectionKeepAliveMs;
            }
        }).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout((int)conf.connectionTimeoutMs).setConnectTimeout((int)conf.connectionTimeoutMs).setConnectionRequestTimeout((int)conf.requestTimeoutMs).build()).build();
        this.requestBuilder = () -> {
            HttpPost request = new HttpPost(conf.pushUrl);
            request.addHeader("Content-Type", conf.contentType);
            conf.tenantId.ifPresent(tenant -> request.addHeader("X-Scope-OrgID", tenant));
            conf.basicAuthToken().ifPresent(token -> request.setHeader("Authorization", "Basic " + token));
            return request;
        };
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    @Override
    public LokiResponse send(ByteBuffer batch) throws Exception {
        HttpPost request = this.requestBuilder.get();
        if (batch.hasArray()) {
            request.setEntity((HttpEntity)new ByteArrayEntity(batch.array(), batch.position(), batch.remaining()));
        } else {
            int len = batch.remaining();
            if (len > this.bodyBuffer.length) {
                this.bodyBuffer = new byte[len];
            }
            batch.get(this.bodyBuffer, 0, len);
            request.setEntity((HttpEntity)new ByteArrayEntity(this.bodyBuffer, 0, len));
        }
        CloseableHttpResponse r = this.client.execute((HttpUriRequest)request);
        HttpEntity entity = r.getEntity();
        return new LokiResponse(r.getStatusLine().getStatusCode(), entity != null ? EntityUtils.toString((HttpEntity)entity) : "");
    }

    @Override
    public HttpConfig getConfig() {
        return this.conf;
    }
}

