/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import com.github.loki4j.client.http.HttpConfig;
import com.github.loki4j.client.http.Loki4jHttpClient;
import com.github.loki4j.client.pipeline.PipelineConfig;
import com.github.loki4j.logback.HttpSender;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractHttpSender
implements HttpSender {
    private String url = "http://localhost:3100/loki/api/v1/push";
    private Optional<String> tenantId = Optional.empty();
    private long connectionTimeoutMs = 30000L;
    private long requestTimeoutMs = 5000L;
    private BasicAuth auth;

    protected void fillHttpConfig(HttpConfig.Builder builder) {
        builder.setPushUrl(this.url).setTenantId(this.tenantId).setConnectionTimeoutMs(this.connectionTimeoutMs).setRequestTimeoutMs(this.requestTimeoutMs).setUsername(Optional.ofNullable(this.auth).map(a -> a.username)).setPassword(Optional.ofNullable(this.auth).map(a -> a.password));
    }

    @Override
    public Function<HttpConfig, Loki4jHttpClient> getHttpClientFactory() {
        return PipelineConfig.defaultHttpClientFactory;
    }

    public void setConnectionTimeoutMs(long connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public void setRequestTimeoutMs(long requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAuth(BasicAuth auth) {
        this.auth = auth;
    }

    public void setTenantId(String tenant) {
        this.tenantId = Optional.ofNullable(tenant);
    }

    public static final class BasicAuth {
        String username;
        String password;

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

