/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.status.StatusListener;
import com.github.loki4j.client.pipeline.AsyncBufferPipeline;
import com.github.loki4j.client.pipeline.PipelineConfig;
import com.github.loki4j.logback.HttpSender;
import com.github.loki4j.logback.InternalLogger;
import com.github.loki4j.logback.JavaHttpSender;
import com.github.loki4j.logback.JsonEncoder;
import com.github.loki4j.logback.Loki4jEncoder;
import com.github.loki4j.logback.StatusPrinter;
import java.util.concurrent.atomic.AtomicLong;

public class Loki4jAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private int batchMaxItems = 1000;
    private int batchMaxBytes = 0x400000;
    private long batchTimeoutMs = 60000L;
    private long sendQueueMaxBytes = this.batchMaxBytes * 10;
    private int maxRetries = 2;
    public long minRetryBackoffMs = 500L;
    public long maxRetryBackoffMs = 60000L;
    public int maxRetryJitterMs = 500;
    private boolean dropRateLimitedBatches = false;
    private long internalQueuesCheckTimeoutMs = 25L;
    private boolean verbose = false;
    private boolean metricsEnabled = false;
    private boolean drainOnStop = true;
    private boolean useDirectBuffers = true;
    private Loki4jEncoder encoder;
    private HttpSender sender;
    private AsyncBufferPipeline pipeline;
    private AtomicLong droppedEventsCount = new AtomicLong(0L);
    private PipelineConfig.Builder pipelineBuilder = PipelineConfig.builder();

    public void start() {
        if (this.getStatusManager() != null && this.getStatusManager().getCopyOfStatusListenerList().isEmpty()) {
            StatusPrinter statusListener = new StatusPrinter(this.verbose ? 0 : 1);
            statusListener.setContext(this.getContext());
            statusListener.start();
            this.getStatusManager().add((StatusListener)statusListener);
        }
        this.addInfo(String.format("Starting with batchMaxItems=%s, batchMaxBytes=%s, batchTimeout=%s, sendQueueMaxBytes=%s...", this.batchMaxItems, this.batchMaxBytes, this.batchTimeoutMs, this.sendQueueMaxBytes));
        if (this.sendQueueMaxBytes < (long)(this.batchMaxBytes * 5)) {
            this.addWarn("Configured value sendQueueMaxBytes=" + this.sendQueueMaxBytes + " is less than `batchMaxBytes * 5`");
            this.sendQueueMaxBytes = this.batchMaxBytes * 5;
        }
        if (this.encoder == null) {
            this.addWarn("No encoder specified in the config. Using JsonEncoder with default settings");
            this.encoder = new JsonEncoder();
        }
        this.encoder.setContext(this.context);
        this.encoder.start();
        if (this.sender == null) {
            this.addWarn("No sender specified in the config. Trying to use JavaHttpSender with default settings");
            this.sender = new JavaHttpSender();
        }
        PipelineConfig pipelineConf = this.pipelineBuilder.setName(this.getName() == null ? "none" : this.getName()).setBatchMaxItems(this.batchMaxItems).setBatchMaxBytes(this.batchMaxBytes).setBatchTimeoutMs(this.batchTimeoutMs).setSortByTime(this.encoder.getSortByTime()).setStaticLabels(this.encoder.getStaticLabels()).setSendQueueMaxBytes(this.sendQueueMaxBytes).setMaxRetries(this.maxRetries).setMinRetryBackoffMs(this.minRetryBackoffMs).setMaxRetryBackoffMs(this.maxRetryBackoffMs).setMaxRetryJitterMs(this.maxRetryJitterMs).setDropRateLimitedBatches(this.dropRateLimitedBatches).setInternalQueuesCheckTimeoutMs(this.internalQueuesCheckTimeoutMs).setUseDirectBuffers(this.useDirectBuffers).setDrainOnStop(this.drainOnStop).setMetricsEnabled(this.metricsEnabled).setWriter(this.encoder.getWriterFactory()).setHttpConfig(this.sender.getConfig()).setHttpClientFactory(this.sender.getHttpClientFactory()).setInternalLoggingFactory(source -> new InternalLogger(source, (ContextAware)this)).build();
        this.pipeline = new AsyncBufferPipeline(pipelineConf);
        this.pipeline.start();
        super.start();
        this.addInfo("Successfully started");
    }

    public void stop() {
        if (!super.isStarted()) {
            return;
        }
        this.addInfo("Stopping...");
        super.stop();
        this.pipeline.stop();
        this.encoder.stop();
        this.addInfo("Successfully stopped");
    }

    protected void append(ILoggingEvent event) {
        boolean appended = this.pipeline.append(event.getTimeStamp(), this.encoder.timestampToNanos(event.getTimeStamp()), () -> this.encoder.eventToStream(event), () -> this.encoder.eventToMessage(event));
        if (!appended) {
            this.reportDroppedEvents();
        }
    }

    private void reportDroppedEvents() {
        long dropped = this.droppedEventsCount.incrementAndGet();
        if (dropped == 1L || dropped <= 90L && dropped % 20L == 0L || dropped <= 900L && dropped % 100L == 0L || dropped <= 900000L && dropped % 1000L == 0L || dropped <= 9000000L && dropped % 10000L == 0L || dropped <= 900000000L && dropped % 1000000L == 0L || dropped > 1000000000L) {
            this.addWarn(String.format("Backpressure: %s messages dropped. Check `sendQueueSizeBytes` setting", dropped));
            if (dropped > 1000000000L) {
                this.addWarn(String.format("Resetting dropped message counter from %s to 0", dropped));
                this.droppedEventsCount.set(0L);
            }
        }
    }

    void waitSendQueueIsEmpty(long timeoutMs) {
        this.pipeline.waitSendQueueIsEmpty(timeoutMs);
    }

    long droppedEventsCount() {
        return this.droppedEventsCount.get();
    }

    public void setBatchMaxItems(int batchMaxItems) {
        this.batchMaxItems = batchMaxItems;
    }

    public void setBatchMaxBytes(int batchMaxBytes) {
        this.batchMaxBytes = batchMaxBytes;
    }

    public void setBatchTimeoutMs(long batchTimeoutMs) {
        this.batchTimeoutMs = batchTimeoutMs;
    }

    public void setSendQueueMaxBytes(long sendQueueMaxBytes) {
        this.sendQueueMaxBytes = sendQueueMaxBytes;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setMinRetryBackoffMs(long minRetryBackoffMs) {
        this.minRetryBackoffMs = minRetryBackoffMs;
    }

    public void setMaxRetryBackoffMs(long maxRetryBackoffMs) {
        this.maxRetryBackoffMs = maxRetryBackoffMs;
    }

    public void setMaxRetryJitterMs(int maxRetryJitterMs) {
        this.maxRetryJitterMs = maxRetryJitterMs;
    }

    public void setDropRateLimitedBatches(boolean dropRateLimitedBatches) {
        this.dropRateLimitedBatches = dropRateLimitedBatches;
    }

    public void setRetryTimeoutMs(long retryTimeoutMs) {
        this.addWarn("The setting `retryTimeoutMs` is no longer supported. See `minRetryBackoffMs` and `maxRetryBackoffMs`");
    }

    @DefaultClass(value=JsonEncoder.class)
    public void setFormat(Loki4jEncoder encoder) {
        this.encoder = encoder;
    }

    HttpSender getSender() {
        return this.sender;
    }

    @DefaultClass(value=JavaHttpSender.class)
    public void setHttp(HttpSender sender) {
        this.sender = sender;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public void setDrainOnStop(boolean drainOnStop) {
        this.drainOnStop = drainOnStop;
    }

    public void setUseDirectBuffers(boolean useDirectBuffers) {
        this.useDirectBuffers = useDirectBuffers;
    }

    public void setInternalQueuesCheckTimeoutMs(long internalQueuesCheckTimeoutMs) {
        this.internalQueuesCheckTimeoutMs = internalQueuesCheckTimeoutMs;
    }
}

