/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.event;

import com.github.parboiled1.grappa.exceptions.GrappaException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.parboiled.BaseParser;
import org.parboiled.Context;

public abstract class EventBusParser<V>
extends BaseParser<V> {
    private final EventBus bus = new EventBus();
    private final Map<String, Constructor<?>> eventMap = Maps.newHashMap();

    protected final void addEvent(@Nonnull String eventName, @Nonnull Class<?> eventClass) {
        Preconditions.checkNotNull((Object)eventName);
        Preconditions.checkNotNull(eventClass);
        try {
            Constructor<?> constructor = eventClass.getConstructor(Context.class);
            this.eventMap.put(eventName, constructor);
        }
        catch (NoSuchMethodException e) {
            throw new GrappaException("cannot find constructor for event class", e);
        }
    }

    public final void addListener(@Nonnull Object listener) {
        this.bus.register(Preconditions.checkNotNull((Object)listener));
    }

    public boolean fireEvent(@Nonnull String eventName) {
        Object event;
        Preconditions.checkNotNull((Object)eventName);
        Constructor<?> constructor = this.eventMap.get(eventName);
        if (constructor == null) {
            throw new GrappaException("no event class for name " + eventName);
        }
        try {
            event = constructor.newInstance(this.getContext());
        }
        catch (InstantiationException e) {
            throw new GrappaException("cannot instantiate event class", e);
        }
        catch (IllegalAccessException e) {
            throw new GrappaException("cannot instantiate event class", e);
        }
        catch (InvocationTargetException e) {
            throw new GrappaException("cannot instantiate event class", e);
        }
        this.bus.post(event);
        return true;
    }
}

