/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers;

import com.github.parboiled1.grappa.exceptions.GrappaException;
import com.google.common.eventbus.EventBus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Untainted;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public final class EventBusMatcher
extends AbstractMatcher {
    private final Matcher delegate = (Matcher)this.getChildren().get(0);
    private final EventBus bus;
    private final Constructor<?> constructor;

    public EventBusMatcher(Rule delegate, EventBus bus, String eventName, @Untainted Constructor<?> constructor) {
        super(delegate, "EVENT: " + eventName);
        this.bus = bus;
        this.constructor = constructor;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (!this.delegate.getSubContext(context).runMatcher()) {
            return false;
        }
        this.bus.post(this.buildEvent(context));
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        return null;
    }

    private <V> Object buildEvent(MatcherContext<V> ctx) {
        try {
            return this.constructor.newInstance(ctx);
        }
        catch (InstantiationException e) {
            throw new GrappaException("cannot instantiate event class", e);
        }
        catch (IllegalAccessException e) {
            throw new GrappaException("cannot instantiate event class", e);
        }
        catch (InvocationTargetException e) {
            throw new GrappaException("cannot instantiate event class", e);
        }
    }
}

