/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.join;

import com.github.parboiled1.grappa.matchers.join.JoinMatcher;
import com.google.common.annotations.Beta;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;

@Beta
public final class BoundedBothJoinMatcher
extends JoinMatcher {
    private final int minCycles;
    private final int maxCycles;

    public BoundedBothJoinMatcher(Rule joined, Rule joining, int minCycles, int maxCycles) {
        super(joined, joining);
        this.minCycles = minCycles;
        this.maxCycles = maxCycles;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        int nrCycles;
        if (!this.joined.getSubContext(context).runMatcher()) {
            return false;
        }
        int beforeCycle = context.getCurrentIndex();
        if (!this.matchJoining(context, beforeCycle)) {
            context.setCurrentIndex(beforeCycle);
            if (this.minCycles != 1) {
                return false;
            }
        }
        for (nrCycles = 2; nrCycles < this.maxCycles; ++nrCycles) {
            beforeCycle = context.getCurrentIndex();
            if (this.matchJoining(context, beforeCycle) && this.joined.getSubContext(context).runMatcher()) {
                continue;
            }
            context.setCurrentIndex(beforeCycle);
            break;
        }
        if (nrCycles < this.minCycles) {
            return false;
        }
        context.createNode();
        return true;
    }
}

