/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.join;

import com.github.parboiled1.grappa.matchers.join.JoinMatcher;
import com.google.common.annotations.Beta;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;

@Beta
public final class BoundedDownJoinMatcher
extends JoinMatcher {
    private final int minCycles;

    public BoundedDownJoinMatcher(Rule joined, Rule joining, int minCycles) {
        super(joined, joining);
        this.minCycles = minCycles;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (!this.joined.getSubContext(context).runMatcher()) {
            if (this.minCycles != 0) {
                return false;
            }
            context.createNode();
            return true;
        }
        int beforeCycle = context.getCurrentIndex();
        if (!this.matchJoining(context, beforeCycle)) {
            context.setCurrentIndex(beforeCycle);
            if (this.minCycles != 1) {
                return false;
            }
            context.createNode();
            return true;
        }
        int cycles = 2;
        while (this.matchJoining(context, beforeCycle = context.getCurrentIndex()) && this.joined.getSubContext(context).runMatcher()) {
            ++cycles;
        }
        context.setCurrentIndex(beforeCycle);
        if (cycles < this.minCycles) {
            return false;
        }
        context.createNode();
        return true;
    }
}

