/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.join;

import com.github.parboiled1.grappa.matchers.join.JoinMatcher;
import com.google.common.annotations.Beta;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;

@Beta
public final class BoundedUpJoinMatcher
extends JoinMatcher {
    private final int maxCycles;

    public BoundedUpJoinMatcher(Rule joined, Rule joining, int maxCycles) {
        super(joined, joining);
        this.maxCycles = maxCycles;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (!this.joined.getSubContext(context).runMatcher()) {
            context.createNode();
            return true;
        }
        int beforeCycle = context.getCurrentIndex();
        if (!this.matchJoining(context, beforeCycle)) {
            context.setCurrentIndex(beforeCycle);
            return true;
        }
        for (int cycles = 2; cycles < this.maxCycles; ++cycles) {
            beforeCycle = context.getCurrentIndex();
            if (this.matchJoining(context, beforeCycle) && this.joined.getSubContext(context).runMatcher()) {
                continue;
            }
            context.setCurrentIndex(beforeCycle);
            break;
        }
        context.createNode();
        return true;
    }
}

